#version 330 compatibility

uniform sampler2D colortex0;
in vec2 texcoord;

/*
const int colortex0Format = RGB16F;
*/

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

vec3 toneMapping(vec3 x) {
    float a = 2.5;
    float b = 0.05;
    float c = 1.6;
    float d = 0.6;
    float e = 0.9;
    return clamp((x * (a * x + b)) / (x * (c * x + d) + e), 0.0, 1.0);
}

void main() {
    vec4 tex = texture(colortex0, texcoord);

    tex.rgb = toneMapping(tex.rgb);

    float lum = dot(tex.rgb, vec3(0.2126, 0.7152, 0.0722));
    float satFactor = 1.3;
    tex.rgb = mix(vec3(lum), tex.rgb, satFactor);

    color = vec4(pow(tex.rgb, vec3(1.0 / 2.2)), tex.a);
}