#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform vec3 fogColor;
uniform float far;
uniform float near;

uniform mat4 gbufferProjectionInverse;

in vec2 texcoord;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
  vec4 homPos = projectionMatrix * vec4(position, 1.0);
  return homPos.xyz / homPos.w;
}

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

void main() {
  color = texture(colortex0, texcoord);

  float depth = texture(depthtex0, texcoord).r;
  if(depth == 1.0){
    return;
  }

  vec2 lightmap = pow(texture(colortex1, texcoord).rg, vec2(3.0)) + 0.115;

  vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
  vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
  float dist = length(viewPos) / far;
  float fogFactor = exp(-5 * (0.8 - dist));

  float d0 = texture(depthtex0, texcoord).r;
	float d1 = texture(depthtex1, texcoord).r;

	float diff = step(0.000000001, abs(d0 - d1));
	if (diff == 0.0) return;
	color *= vec4(vec3(diff), 1.0);

  color.rgb = mix(color.rgb, pow(fogColor * lightmap.g,vec3(2.2)), clamp(fogFactor, 0.0, 1.0));
}