#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform int isEyeInWater;
uniform float near;
uniform float far;

in vec2 texcoord;
layout(location = 0) out vec4 color;

float linearizeDepth(float depth, float near, float far) {
    float z = depth * 2.0 - 1.0;
    return (2.0 * near * far) / (far + near - z * (far - near));
}

void main() {
    color = texture(colortex0, texcoord);
    float lum = dot(color.rgb, vec3(0.2126, 0.7152, 0.0722));
    float factor = smoothstep(0.0, 0.3, 1.0 - lum);

    float d0 = texture(depthtex0, texcoord).r;
    float d1 = texture(depthtex1, texcoord).r;

    if(d0 >= 1.0 || d1 >= 1.0) return;

    float ld0 = linearizeDepth(d0, near, far);
    float ld1 = linearizeDepth(d1, near, far);

    float diff;
    if (isEyeInWater == 1) {
        diff = (ld0 - near) / (far - near);
    } else {
        diff = abs(ld0 - ld1) / far;
    }

    if(diff < 0.00001) return;

    float scale = 4.0;
    vec3 tint = vec3(0.1, 0.007, 0.0);
    color.rgb -= diff * scale * tint;
    color.rgb = clamp(color.rgb, 0.0, 1.0);

    float edgeFactor = smoothstep(0.002, 0.0, diff);
    edgeFactor = pow(edgeFactor, 3.0);

    float aquaBrightness = lum;
    vec3 aquaColor = vec3(0.3, 0.8, 1.0) * aquaBrightness;
    color.rgb += aquaColor * edgeFactor;

    color.rgb = clamp(color.rgb, 0.0, 1.0);
}