#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform int isEyeInWater;
uniform float near;
uniform float far;

in vec2 texcoord;

layout(location = 0) out vec4 color;

const vec3 gray = vec3(0.2126, 0.7152, 0.0722);
const vec3 edgeTint = vec3(0.6, 0.9, 1.0);
const vec3 volTint = vec3(0.1, 0.01, 0.0);
const float scale = 0.02;

float linearizeDepth(float depth) {
    float z = depth * 2.0 - 1.0;
    return (2.0 * near * far) / (far + near - z * (far - near));
}

void main() {
    float d0 = texture(depthtex0, texcoord).r;
    float d1 = texture(depthtex1, texcoord).r;

    if (isEyeInWater != 1 && (d0 >= 1.0 || d1 >= 1.0)) {
        color = texture(colortex0, texcoord);
        return;
    }

    color = texture(colortex0, texcoord);
    float lum = dot(color.rgb, gray);

    float ld0 = linearizeDepth(d0);
    float ld1 = linearizeDepth(d1);

    float diff = (isEyeInWater == 1) ? abs(ld0 - near) : abs(ld0 - ld1);

    if (diff < 0.00001) return;

    float edgeFactor = smoothstep(0.002, 0.0, diff / far);

    vec3 edgeColor = edgeTint * lum;
    color.rgb += edgeColor * edgeFactor;
    color.rgb -= diff * scale * volTint;
    color.rgb = clamp(color.rgb, 0.0, 1.0);
}