#version 330 compatibility

#include "distort.glsl"

#define FRESNEL_STRENGTH 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D depthtex0;
uniform sampler2D shadowtex0;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;

uniform vec3 shadowLightPosition;

const vec3 blocklightColor = vec3(3.5, 0.5, 0.5);
const vec3 skylightColor = vec3(0.2, 0.1, 0.6) * 0.5;
const vec3 sunlightColor = vec3(2.5, 0.8, 1.5) * 0.1;
const vec3 ambientLight = vec3(0.01, 0.011, 0.013);
const float fresnelIntensity = 0.1 * FRESNEL_STRENGTH;

const int times[6] = int[](0, 6000, 12785, 18000, 23215, 24000);
const float values[6] = float[](0.7, 0.8, 0.0, 0.02, 0.0, 0.7);

in vec2 texcoord;

layout(location = 0) out vec4 color;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position) {
    vec4 homPos = projectionMatrix * vec4(position, 1.0);
    return homPos.xyz / homPos.w;
}

void main() {
    color = texture(colortex0, texcoord);

    float depth = texture(depthtex0, texcoord).r;
    if (depth == 1.0) return;

    vec3 main = texture(colortex0, texcoord).rgb;
    vec2 lightmap = texture(colortex1, texcoord).rg;
    vec3 normalData = texture(colortex2, texcoord).rgb;

    vec3 normal = normalData * 2.0 - 1.0;
    
    vec3 NDCPos = vec3(texcoord, depth) * 2.0 - 1.0;
    vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
    vec3 feetPlayerPos = (gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz;
    
    vec3 shadowViewPos = (shadowModelView * vec4(feetPlayerPos, 1.0)).xyz;
    vec4 shadowClipPos = shadowProjection * vec4(shadowViewPos, 1.0);
    shadowClipPos.z -= 0.001;
    shadowClipPos.xyz = distortShadowClipPos(shadowClipPos.xyz);
    vec3 shadowScreenPos = (shadowClipPos.xyz / shadowClipPos.w) * 0.5 + 0.5;
    
    float shadow = step(shadowScreenPos.z, texture(shadowtex0, shadowScreenPos.xy).r);
    
    vec3 worldLightVector = mat3(gbufferModelViewInverse) * normalize(shadowLightPosition);
    float NdotL = max(dot(worldLightVector, normal), 0.0);
    
    lightmap = pow(lightmap, vec2(3.0));
    
    float fresnel = 0.0;
	if (FRESNEL_STRENGTH != 0.0) {
 	   vec3 psNormal = inverse(mat3(gbufferModelViewInverse)) * normal;
	    vec3 viewDir = normalize(feetPlayerPos - viewPos);
 	   fresnel = pow(1.0 - dot(viewDir, psNormal), 3.0) * 0.1;
	}

    vec3 blocklight = lightmap.r * blocklightColor;
    vec3 skylight = lightmap.g * skylightColor;
    vec3 sunlight = sunlightColor * NdotL * shadow * lightmap.g;
    vec3 ambient = ambientLight;
    
    main = pow(main, vec3(2.2));
    main += vec3(fresnel) * fresnelIntensity;
    color.rgb = main * (blocklight + skylight + sunlight + ambient) * 0.4;
}