#version 330 compatibility

#define SHADOW_RESOLUTION 1024 // [128 192 256 384 512 768 1024 1536 2048 3072 4096 6144 8192]
#define SHADOW_ACCURACY 128 // [32 48 64 96 128 192 256 384 512]

const float sunPathRotation = 30.0;

uniform sampler2D gtexture;

in vec2 texcoord;
in vec4 glcolor;

layout(location = 0) out vec4 color;

const int shadowMapResolution = SHADOW_RESOLUTION;
const float shadowDistance = SHADOW_ACCURACY;

void main() {
  color = texture(gtexture, texcoord) * glcolor;
  if(color.a < 0.1){
    discard;
  }
}