#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float far;
uniform vec3 fogColor;
uniform int isEyeInWater;

uniform mat4 gbufferProjectionInverse;

in vec2 texcoord;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
  vec4 homPos = projectionMatrix * vec4(position, 1.0);
  return homPos.xyz / homPos.w;
}

layout(location = 0) out vec4 color;

void main() {
  color = texture(colortex0, texcoord);
  float depth = texture(depthtex0, texcoord).r;

  vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
  vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
  float dist = length(viewPos) / far;
  
  float fogStart, fogEnd;
  if (isEyeInWater == 2 || isEyeInWater == 3) {
      fogStart = 0.0;
      fogEnd   = 0.1 * far;
  } else {
      fogStart = 0.0;
      fogEnd   = far;
  }
  float fogFactor = smoothstep(fogStart, fogEnd, dist * far);

  vec3 finalFog = pow(fogColor * vec3(0.96, 0.92, 0.8), vec3(2.2));
  color.rgb = mix(color.rgb, finalFog, fogFactor);
}