#version 330 compatibility

#define BLOOM_INTENSITY 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

const bool colortex0MipmapEnabled = true;
const float intensity = 0.05 * BLOOM_INTENSITY;

uniform sampler2D colortex0;

in vec2 texcoord;

layout(location = 0) out vec4 color;

void main() {
    color = texture(colortex0, texcoord);
    if (BLOOM_INTENSITY == 0.0) return;

    vec4 bloom = textureLod(colortex0, texcoord, 8.0) + textureLod(colortex0, texcoord, 6.0) + textureLod(colortex0, texcoord, 4.0);
    bloom = max(pow(bloom, vec4(2.5)), vec4(0.0));
    bloom = bloom / (bloom + vec4(1.0));
    color += pow(bloom,vec4(2.0)) * intensity;
}