#version 330 compatibility

uniform int renderStage;
uniform float viewHeight;
uniform float viewWidth;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;
uniform vec3 fogColor;
uniform vec3 skyColor;
uniform vec3 sunPosition;

in vec4 glcolor;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

void main() {
	if (renderStage == MC_RENDER_STAGE_STARS) {
		color = glcolor * 0.3;
	} else {
		vec2 screenUV = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
		vec4 ndcPos = vec4(screenUV, 1.0, 1.0) * 2.0 - 1.0;
		vec4 tmp = gbufferProjectionInverse * ndcPos;
		vec3 pos = normalize(tmp.xyz / tmp.w);

		float upDot = dot(pos, gbufferModelView[1].xyz);
		vec3 baseColor = skyColor * mix(vec3(0.6, 0.7, 0.5), skyColor * vec3(0.4, 0.4, 0.4), upDot);
		float fogFactor = 0.025 / (max(upDot, 0.0) * max(upDot, 0.0) + 0.025);
		vec3 col = mix(baseColor, fogColor * vec3(0.75, 0.75, 0.65), fogFactor);
		
		vec4 sunClip = gbufferProjection * vec4(sunPosition, 1.0);
		vec2 diff = screenUV - (sunClip.xy / sunClip.w) * 0.5 - 0.5;
		diff.x *= viewWidth / viewHeight;
		col += fogColor * vec3(1.0, 0.5, 0.2) * exp(-length(diff) * 5.0);
		
		color = vec4(pow(col, vec3(2.2)), 0.0);
	}
}