/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.yeeterite.extra.mod.items.data.equipment;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.a5ho9999.yeeterite.extra.YeeteriteExtraMod;
import net.a5ho9999.yeeterite.extra.mod.items.data.materials.YeeteriteArmourMaterials;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class YeeteriteArmourItem
extends class_1792 {
    private static final Map<class_1741, class_1293> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)YeeteriteArmourMaterials.Yeeterite, (Object)new class_1293(class_1294.field_5918, 1000, 69, false, false, true)).build();
    private static class_1741 material;

    public YeeteriteArmourItem(class_1741 material, class_1792.class_1793 settings) {
        super(settings);
        YeeteriteArmourItem.material = material;
    }

    public class_1741 getMaterial() {
        return material;
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_1657 player;
        if (!world.method_8608() && YeeteriteExtraMod.Config.FireResistArmour() && entity instanceof class_1657 && YeeteriteArmourItem.hasFullSuitOfArmorOn(player = (class_1657)entity)) {
            this.evaluateArmorEffects(player);
        }
        super.method_7888(stack, world, entity, slot);
    }

    private void evaluateArmorEffects(class_1657 player) {
        for (Map.Entry<class_1741, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_1741 mapArmorMaterial = entry.getKey();
            class_1293 mapStatusEffect = entry.getValue();
            if (!YeeteriteArmourItem.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(class_1657 player, class_1741 mapArmorMaterial, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = player.method_6059(mapStatusEffect.method_5579());
        if (YeeteriteArmourItem.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.method_6092(new class_1293(mapStatusEffect.method_5579(), mapStatusEffect.method_5584(), mapStatusEffect.method_5578()));
        }
    }

    public static boolean hasFullSuitOfArmourOn(class_1297 entity) {
        class_1657 playerEntity;
        class_1657 class_16572 = playerEntity = entity instanceof class_1657 ? (class_1657)entity : null;
        if (playerEntity != null) {
            return YeeteriteArmourItem.hasFullSuitOfArmorOn(playerEntity);
        }
        return false;
    }

    private static boolean hasFullSuitOfArmorOn(class_1657 player) {
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        class_1799 chestplate = player.method_6118(class_1304.field_6174);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 boots = player.method_6118(class_1304.field_6166);
        return !helmet.method_7960() && !chestplate.method_7960() && !leggings.method_7960() && !boots.method_7960();
    }

    public static boolean hasCorrectArmorOn(class_1741 material, class_1297 entity) {
        try {
            class_1657 playerEntity;
            class_1657 class_16572 = playerEntity = entity instanceof class_1657 ? (class_1657)entity : null;
            if (playerEntity != null) {
                return YeeteriteArmourItem.hasCorrectArmorOn(material, playerEntity);
            }
        }
        catch (Exception x) {
            return false;
        }
        return false;
    }

    private static boolean hasCorrectArmorOn(class_1741 material, class_1657 player) {
        class_1792 bootStack = player.method_6118(class_1304.field_6169).method_7909();
        class_1792 leggingStack = player.method_6118(class_1304.field_6174).method_7909();
        class_1792 chestplateStack = player.method_6118(class_1304.field_6172).method_7909();
        class_1792 helmetStack = player.method_6118(class_1304.field_6169).method_7909();
        if (!(bootStack instanceof YeeteriteArmourItem)) {
            return false;
        }
        YeeteriteArmourItem boots = (YeeteriteArmourItem)bootStack;
        if (!(leggingStack instanceof YeeteriteArmourItem)) {
            return false;
        }
        YeeteriteArmourItem leggings = (YeeteriteArmourItem)leggingStack;
        if (!(chestplateStack instanceof YeeteriteArmourItem)) {
            return false;
        }
        YeeteriteArmourItem chestplate = (YeeteriteArmourItem)chestplateStack;
        if (!(helmetStack instanceof YeeteriteArmourItem)) {
            return false;
        }
        YeeteriteArmourItem helmet = (YeeteriteArmourItem)helmetStack;
        if (boots == null || leggings == null || chestplate == null || helmet == null) {
            return false;
        }
        return helmet.getMaterial() == material && chestplate.getMaterial() == material && leggings.getMaterial() == material && boots.getMaterial() == material;
    }
}

