package eu.gflash.quickcraft.client;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9884;

public abstract class InventoryHelper {
	private static boolean craftScheduled = false;

	private InventoryHelper() {}

	public static void scheduleCraft(){	// craft on the next client tick
		craftScheduled = true;
	}

	public static void init(){	// register craft on tick
		ClientTickEvents.START_CLIENT_TICK.register((class_310 minecraftClient)->{
			if(craftScheduled){
				craftScheduled = false;
				InventoryHelper.craft();
			}
		});
	}

	public static void craft(){	// craft the item on the crafting table
		class_310 client = class_310.method_1551();
		class_746 ply = client.field_1724;
		class_636 im = client.field_1761;
		if(im == null || ply == null) return;
		class_1661 inv = ply.method_31548();
		class_9884 rsh = getCraftingScreenHandler();
		if(rsh != null){
			int resultSlotIndex = rsh.method_61627().method_34266();
			class_1799 outStack = getResultStack();
			if(InputHelper.isAltPressed() || (outStack != null && !hasSpace(inv, outStack))){
				ply.method_7290(true);
			}
			im.method_2906(rsh.field_7763, resultSlotIndex, 0, class_1713.field_7794, ply);
		}
	}

	public static class_1799 getResultStack(){ // crafting table result
		class_9884 rsh = getCraftingScreenHandler();
		if(rsh == null) return null;
		int resultSlotIndex = rsh.method_61627().method_34266();
		return rsh.field_7761.get(resultSlotIndex).method_7677();
	}

	public static class_9884 getCraftingScreenHandler(){	// get crafting area screen handler (table/player)
		class_746 ply = class_310.method_1551().field_1724;
		if(ply == null) return null;
		class_1703 csh = ply.field_7512;
		if(csh instanceof class_1714 || csh instanceof class_1723)
			return ((class_9884) csh);
		return null;
	}

	protected static boolean hasSpace(class_1661 inv, class_1799 outStack){	// player inventory has space for items
		return outStack.method_7960() || inv.method_7376() >= 0 || inv.method_7390(outStack) >= 0;
	}
}
