/*
 * Decompiled with CFR 0.152.
 */
package hibi.blind_me;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import hibi.blind_me.Main;
import hibi.blind_me.Networking;
import hibi.blind_me.config.ConfigScreen;
import hibi.blind_me.config.ServerEffect;
import hibi.blind_me.config.ServerOptions;
import java.lang.runtime.SwitchBootstraps;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public final class Command {
    private static final String K_EFFECT_ALREADY_SET = "blindme.command.effect_already_set";
    private static final String K_EFFECT_ALREADY_UNSET = "blindme.command.effect_already_unset";
    private static final String K_EFFECT_SET = "blindme.command.set_effect";
    private static final String K_EFFECT_OFF = "blindme.command.disable_effect";
    private static final String K_EFFECT_UNSET = "blindme.command.unset_effect";
    private static final String K_OPTIONS_LOCKED = "blindme.command.options_locked";
    private static final String K_ENFORCED_BY_SERVER = "blindme.command.enforced_by_server";
    private static final String K_PRINT_SET = "blindme.command.current";
    private static final String K_PRINT_NONE = "blindme.command.current.none";

    private Command() {
    }

    public static void registerCallback(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blindme").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").then(ClientCommandManager.literal((String)"off").executes(src -> Command.worldSubcommand((CommandContext<FabricClientCommandSource>)src, ServerEffect.OFF)))).then(ClientCommandManager.literal((String)"blindness").executes(src -> Command.worldSubcommand((CommandContext<FabricClientCommandSource>)src, ServerEffect.BLINDNESS)))).then(ClientCommandManager.literal((String)"darkness").executes(src -> Command.worldSubcommand((CommandContext<FabricClientCommandSource>)src, ServerEffect.DARKNESS)))).then(ClientCommandManager.literal((String)"default").executes(src -> Command.worldSubcommand((CommandContext<FabricClientCommandSource>)src, null))))).then(ClientCommandManager.literal((String)"query").executes(Command::printSubcommand))).executes(Command::settingsSubcommand));
    }

    private static int worldSubcommand(CommandContext<FabricClientCommandSource> cmd, @Nullable ServerEffect ef) {
        String uniqueId = Networking.uniqueId;
        if (uniqueId == null) {
            throw new IllegalStateException("Command called outside of a world");
        }
        if (Networking.serverEnforced && !Networking.isOpForBypass) {
            ((FabricClientCommandSource)cmd.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)K_ENFORCED_BY_SERVER).method_27692(class_124.field_1061));
            return 0;
        }
        ServerOptions opts = Networking.getServerOptions();
        if (opts.locked()) {
            ((FabricClientCommandSource)cmd.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)K_OPTIONS_LOCKED).method_27692(class_124.field_1061));
            return 0;
        }
        if (opts.effect() == ef) {
            ((FabricClientCommandSource)cmd.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)(ef == null ? K_EFFECT_ALREADY_UNSET : K_EFFECT_ALREADY_SET)));
            return 0;
        }
        Main.CONFIG.setEffectForServer(uniqueId, ef);
        FabricClientCommandSource fabricClientCommandSource = (FabricClientCommandSource)cmd.getSource();
        ServerEffect serverEffect = ef;
        int n = 0;
        fabricClientCommandSource.sendFeedback((class_2561)(switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"OFF", "BLINDNESS", "DARKNESS"}, (ServerEffect)serverEffect, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2561.method_43471((String)K_EFFECT_OFF);
            case 1 -> class_2561.method_43469((String)K_EFFECT_SET, (Object[])new Object[]{class_2561.method_43471((String)"effect.minecraft.blindness")});
            case 2 -> class_2561.method_43469((String)K_EFFECT_SET, (Object[])new Object[]{class_2561.method_43471((String)"effect.minecraft.darkness")});
            case -1 -> class_2561.method_43471((String)K_EFFECT_UNSET);
        }));
        return 0;
    }

    private static int printSubcommand(CommandContext<FabricClientCommandSource> cmd) {
        String uniqueId = Networking.uniqueId;
        FabricClientCommandSource fabricClientCommandSource = (FabricClientCommandSource)cmd.getSource();
        fabricClientCommandSource.sendFeedback((class_2561)(switch (Main.CONFIG.getEffectForServer(uniqueId)) {
            default -> throw new MatchException(null, null);
            case ServerEffect.BLINDNESS -> class_2561.method_43469((String)K_PRINT_SET, (Object[])new Object[]{class_2561.method_43471((String)"effect.minecraft.blindness")});
            case ServerEffect.DARKNESS -> class_2561.method_43469((String)K_PRINT_SET, (Object[])new Object[]{class_2561.method_43471((String)"effect.minecraft.darkness")});
            case ServerEffect.OFF -> class_2561.method_43471((String)K_PRINT_NONE);
        }));
        return 0;
    }

    private static int settingsSubcommand(CommandContext<FabricClientCommandSource> cmd) {
        class_310 client = class_310.method_1551();
        client.method_63588(() -> client.method_1507((class_437)new ConfigScreen(null)));
        return 0;
    }
}

