/*
 * Decompiled with CFR 0.152.
 */
package hibi.blind_me.config;

import hibi.blind_me.EffectManager;
import hibi.blind_me.Networking;
import hibi.blind_me.config.ConfigFile;
import hibi.blind_me.config.ServerEffect;
import hibi.blind_me.config.ServerOptions;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Config {
    public boolean creativeBypass = false;
    public boolean spectatorBypass = true;
    private Map<String, ServerOptions> servers = new HashMap<String, ServerOptions>();
    public boolean disableDarknessPulse = true;
    public ServerEffect defaultServerEffect = ServerEffect.OFF;

    public ServerEffect getEffectForServer(String uniqueId) {
        ServerEffect ef = this.getServerOptions(uniqueId).effect();
        return ef == null ? this.defaultServerEffect : ef;
    }

    public void setEffectForServer(String uniqueId, @Nullable ServerEffect ef) {
        ServerOptions opts = this.servers.getOrDefault(uniqueId, ServerOptions.DEFAULT);
        opts = opts.withEffect(ef);
        this.servers.put(uniqueId, opts);
        ConfigFile.save(this);
        if (ef == null) {
            EffectManager.setDesiredEffect(this.defaultServerEffect);
        } else {
            EffectManager.setDesiredEffect(ef);
        }
    }

    public void setServerOptions(String uniqueId, ServerOptions opts) {
        if (ServerOptions.DEFAULT.equals(opts)) {
            this.servers.remove(uniqueId);
        } else {
            this.servers.put(uniqueId, opts);
        }
        ConfigFile.save(this);
    }

    public ServerOptions getServerOptions(String uniqueId) {
        return this.servers.getOrDefault(uniqueId, ServerOptions.DEFAULT);
    }

    public ServerOptions getDefaults() {
        if (Networking.serverEnforced) {
            return new ServerOptions(Networking.effect, false, Networking.creativeBypass, Networking.spectatorBypass);
        }
        return new ServerOptions(this.defaultServerEffect, false, this.creativeBypass, this.spectatorBypass);
    }

    public void configureInstance() {
        Object object;
        boolean bl;
        boolean bl2;
        Boolean b;
        ServerOptions opts = Networking.getServerOptions();
        ServerOptions defaultOpts = this.getDefaults();
        Object object2 = opts.creativeBypass();
        if (object2 instanceof Boolean) {
            b = object2;
            bl2 = b;
        } else {
            bl2 = defaultOpts.creativeBypass();
        }
        EffectManager.setDisabledCreative(bl2);
        object2 = opts.spectatorBypass();
        if (object2 instanceof Boolean) {
            b = object2;
            bl = b;
        } else {
            bl = defaultOpts.spectatorBypass();
        }
        EffectManager.setDisabledSpectator(bl);
        object2 = opts.effect();
        if (object2 instanceof ServerEffect) {
            Object e = object2;
            object = e;
        } else {
            object = defaultOpts.effect();
        }
        EffectManager.setDesiredEffect(object);
    }
}

