/*
 * Decompiled with CFR 0.152.
 */
package hibi.blind_me.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import hibi.blind_me.Main;
import hibi.blind_me.config.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

public final class ConfigFile {
    private static final String PATH = FabricLoader.getInstance().getConfigDir().toAbsolutePath().resolve("blindme.json").toString();
    private static final String K_SAVE_ERROR = "blindme.error.save";
    private static final String K_SAVE_ERROR_DESCRIPTION = "blindme.error.save.description";

    public static Config load() throws IOException, JsonSyntaxException {
        Config config;
        BufferedReader reader = new BufferedReader(new FileReader(PATH));
        try {
            Config config2;
            String json = Files.readString(Path.of(PATH, new String[0]));
            config = config2 = (Config)new Gson().fromJson(json, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                Main.LOGGER.warn("Config file not found, using default configuration.");
                return new Config();
            }
        }
        reader.close();
        return config;
    }

    public static void save(Config config) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(PATH));){
            String json = new Gson().toJson((Object)config);
            writer.write(json);
        }
        catch (Exception e) {
            Main.LOGGER.error("Could not save the config file", (Throwable)e);
            class_310 client = class_310.method_1551();
            client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)new class_370.class_9037(10000L), (class_2561)class_2561.method_43471((String)K_SAVE_ERROR), (class_2561)class_2561.method_43471((String)K_SAVE_ERROR_DESCRIPTION)));
        }
    }

    private ConfigFile() {
    }
}

