/*
 * Decompiled with CFR 0.152.
 */
package hibi.blind_me.config;

import hibi.blind_me.EffectManager;
import hibi.blind_me.Main;
import hibi.blind_me.Networking;
import hibi.blind_me.config.ConfigFile;
import hibi.blind_me.config.ServerEffect;
import hibi.blind_me.config.ServerOptions;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

public class ConfigScreen
extends class_4667 {
    private boolean changed = false;
    private ServerOptions serverOptions;
    private boolean ingame = false;
    private class_5676<Optional<ServerEffect>> effectButton = null;
    private class_5676<Optional<Boolean>> worldCreativeBypassButton = null;
    private class_5676<Optional<Boolean>> worldSpectatorBypassButton = null;
    private class_4185 lockButton = null;
    private boolean serverEnforced = false;
    private ServerOptions defaults = ServerOptions.DEFAULT;
    private static final String K_TITLE = "blindme.options.title";
    private static final String K_CREATIVE_BYPASS = "blindme.options.creative_bypass";
    private static final String K_SPECTATOR_BYPASS = "blindme.options.spectator_bypass";
    private static final String K_CURRENT_SERVER = "blindme.options.current_world_effect";
    private static final String K_DEFAULT_EFFECT = "blindme.options.default_effect";
    private static final String K_EFFECT_DETAILS_TOOLTIP = "blindme.options.world_effect.tooltip.";
    private static final String K_DISABLE_PULSE = "blindme.options.disable_darkness_pulse";
    private static final String K_DISABLE_PULSE_TOOLTIP = "blindme.options.disable_darkness_pulse.tooltip";
    private static final String K_LOCK_BUTTON = "blindme.options.lock_world";
    private static final String K_LOCK_SCREEN_TITLE = "blindme.options.lock_world.screen.title";
    private static final String K_LOCK_SCREEN_MESSAGE = "blindme.options.lock_world.screen.message";
    private static final String K_UNLOCK_BUTTON = "blindme.options.unlock_world";
    private static final String K_UNLOCK_BUTTON_TOOLTIP = "blindme.options.unlock_world.tooltip";
    private static final String K_LOCK_BUTTON_SERVER_ENFORCED = "blindme.options.lock_world.server_enforced";
    private static final String K_LOCK_BUTTON_SERVER_ENFORCED_TOOLTIP = "blindme.options.lock_world.server_enforced.tooltip";
    private static final String K_WORLD_SETTINGS_SUBTITLE = "blindme.options.subtitle.world_specific";
    private static final String K_WORLD_SPECIFIC_OPTION = "blindme.options.world_specific.tooltip";
    private static final String K_WORLD_CREATIVE_BYPASS = "blindme.options.world.creative_bypass";
    private static final String K_WORLD_SPECTATOR_BYPASS = "blindme.options.world.spectator_bypass";
    private static final String K_SERVER_ENFORCED_TOOLTIP = "blindme.options.server_enforced.tooltip";
    private static final String K_OP_BYPASS_ALLOWED = "blindme.options.server_enforced.ops_bypass.tooltip";

    public ConfigScreen(class_437 parent) {
        super(parent, class_310.method_1551().field_1690, (class_2561)class_2561.method_43471((String)K_TITLE));
        this.serverOptions = Networking.getServerOptions();
        this.serverEnforced = Networking.serverEnforced;
        this.defaults = Main.CONFIG.getDefaults();
    }

    protected void method_60325() {
        this.ingame = this.field_22787.field_1687 != null;
        class_5676 creativeBypassButton = class_5676.method_32613((boolean)Main.CONFIG.creativeBypass).method_57720((class_2561)class_2561.method_43471((String)K_CREATIVE_BYPASS), (button, set) -> {
            boolean bl;
            this.changed = true;
            Main.CONFIG.creativeBypass = set;
            Boolean patt0$temp = this.serverOptions.creativeBypass();
            if (patt0$temp instanceof Boolean) {
                Boolean b = patt0$temp;
                bl = b;
            } else {
                bl = set;
            }
            EffectManager.setDisabledCreative(bl);
        });
        class_5676 spectatorBypassButton = class_5676.method_32613((boolean)Main.CONFIG.spectatorBypass).method_57720((class_2561)class_2561.method_43471((String)K_SPECTATOR_BYPASS), (button, set) -> {
            boolean bl;
            this.changed = true;
            Main.CONFIG.spectatorBypass = set;
            Boolean patt0$temp = this.serverOptions.spectatorBypass();
            if (patt0$temp instanceof Boolean) {
                Boolean b = patt0$temp;
                bl = b;
            } else {
                bl = set;
            }
            EffectManager.setDisabledSpectator(bl);
        });
        this.field_51824.method_20407((class_339)creativeBypassButton, (class_339)spectatorBypassButton);
        class_5676 darknessPulseButton = class_5676.method_32613((boolean)Main.CONFIG.disableDarknessPulse).method_32618(bool -> class_7919.method_47407((class_2561)class_2561.method_43471((String)K_DISABLE_PULSE_TOOLTIP))).method_57720((class_2561)class_2561.method_43471((String)K_DISABLE_PULSE), (button, set) -> {
            this.changed = true;
            Main.CONFIG.disableDarknessPulse = set;
        });
        darknessPulseButton.method_25358(310);
        this.field_51824.method_20407((class_339)darknessPulseButton, null);
        this.addDefaultEffectButton();
        this.addButtonsForCurrentServer();
    }

    private void addDefaultEffectButton() {
        class_5676 button = class_5676.method_32606(ef -> switch (ef) {
            default -> throw new MatchException(null, null);
            case ServerEffect.BLINDNESS -> class_2561.method_43471((String)"effect.minecraft.blindness");
            case ServerEffect.DARKNESS -> class_2561.method_43471((String)"effect.minecraft.darkness");
            case ServerEffect.OFF -> class_5244.field_24333;
        }).method_32624((Object[])ServerEffect.values()).method_32619((Object)Main.CONFIG.defaultServerEffect).method_32618(effect -> class_7919.method_47407((class_2561)class_2561.method_43471((String)(K_EFFECT_DETAILS_TOOLTIP + effect.toString())))).method_57720((class_2561)class_2561.method_43471((String)K_DEFAULT_EFFECT), (_button, value) -> {
            this.changed = true;
            Main.CONFIG.defaultServerEffect = value;
            EffectManager.setDesiredEffect(Main.CONFIG.getEffectForServer(Networking.uniqueId));
        });
        button.method_25358(310);
        this.field_51824.method_20407((class_339)button, null);
    }

    private void addButtonsForCurrentServer() {
        class_5676 spectatorBypassButton;
        class_5676 creativeBypassButton;
        class_7842 worldSettings = new class_7842(310, 27, (class_2561)class_2561.method_43471((String)K_WORLD_SETTINGS_SUBTITLE), this.field_22793);
        this.field_51824.method_20407((class_339)worldSettings, null);
        class_5676 effectButton = class_5676.method_32606(ef -> {
            if (ef.isEmpty()) {
                return class_2561.method_43471((String)(this.serverEnforced ? "effect.blindme.server_default" : "effect.blindme.default"));
            }
            return switch ((ServerEffect)((Object)((Object)ef.get()))) {
                default -> throw new MatchException(null, null);
                case ServerEffect.BLINDNESS -> class_2561.method_43471((String)"effect.minecraft.blindness");
                case ServerEffect.DARKNESS -> class_2561.method_43471((String)"effect.minecraft.darkness");
                case ServerEffect.OFF -> class_5244.field_24333;
            };
        }).method_32624((Object[])new Optional[]{Optional.empty(), Optional.of(ServerEffect.BLINDNESS), Optional.of(ServerEffect.DARKNESS), Optional.of(ServerEffect.OFF)}).method_32619(Optional.ofNullable(this.serverOptions.effect())).method_32618(optional -> {
            ServerEffect effect = optional.orElse(null);
            class_5250 text = this.serverEnforced ? class_2561.method_43471((String)(Networking.isOpForBypass ? K_OP_BYPASS_ALLOWED : K_SERVER_ENFORCED_TOOLTIP)) : class_2561.method_43471((String)(K_EFFECT_DETAILS_TOOLTIP + (effect != null ? effect.toString() : "default")));
            return class_7919.method_47407((class_2561)text);
        }).method_57720((class_2561)class_2561.method_43471((String)K_CURRENT_SERVER), (_button, value) -> {
            this.changed = true;
            this.serverOptions = this.serverOptions.withEffect(value.orElse(null));
            EffectManager.setDesiredEffect(value.orElse(this.defaults.effect()));
        });
        effectButton.method_25358(310);
        this.field_51824.method_20407((class_339)effectButton, null);
        this.effectButton = effectButton;
        this.worldCreativeBypassButton = creativeBypassButton = class_5676.method_32606(bypass -> {
            if (bypass.isEmpty()) {
                return class_2561.method_43471((String)(this.serverEnforced ? "effect.blindme.server_default" : "effect.blindme.default"));
            }
            return (Boolean)bypass.get() != false ? class_5244.field_24332 : class_5244.field_24333;
        }).method_32624((Object[])new Optional[]{Optional.empty(), Optional.of(true), Optional.of(false)}).method_32619(Optional.ofNullable(this.serverOptions.creativeBypass())).method_32618(optional -> class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.serverEnforced ? (Networking.isOpForBypass ? K_OP_BYPASS_ALLOWED : K_SERVER_ENFORCED_TOOLTIP) : K_WORLD_SPECIFIC_OPTION)))).method_57720((class_2561)class_2561.method_43471((String)K_WORLD_CREATIVE_BYPASS), (btn, value) -> {
            this.changed = true;
            this.serverOptions = this.serverOptions.withCreativeBypass(value.orElse(null));
            EffectManager.setDisabledCreative(value.orElse(this.defaults.creativeBypass()));
        });
        this.worldSpectatorBypassButton = spectatorBypassButton = class_5676.method_32606(bypass -> {
            if (bypass.isEmpty()) {
                return class_2561.method_43471((String)(this.serverEnforced ? "effect.blindme.server_default" : "effect.blindme.default"));
            }
            return (Boolean)bypass.get() != false ? class_5244.field_24332 : class_5244.field_24333;
        }).method_32624((Object[])new Optional[]{Optional.empty(), Optional.of(true), Optional.of(false)}).method_32619(Optional.ofNullable(this.serverOptions.spectatorBypass())).method_32618(optional -> class_7919.method_47407((class_2561)class_2561.method_43471((String)(Networking.serverEnforced ? (Networking.isOpForBypass ? K_OP_BYPASS_ALLOWED : K_SERVER_ENFORCED_TOOLTIP) : K_WORLD_SPECIFIC_OPTION)))).method_57720((class_2561)class_2561.method_43471((String)K_WORLD_SPECTATOR_BYPASS), (btn, value) -> {
            this.changed = true;
            this.serverOptions = this.serverOptions.withSpectatorBypass(value.orElse(null));
            EffectManager.setDisabledSpectator(value.orElse(this.defaults.spectatorBypass()));
        });
        this.field_51824.method_20407(this.worldCreativeBypassButton, (class_339)spectatorBypassButton);
        this.addLockButton();
        this.toggleWorldButtons(this.serverOptions.locked());
    }

    private void addLockButton() {
        boolean initiallyLocked = this.serverOptions.locked();
        class_4185 lockButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(initiallyLocked ? K_UNLOCK_BUTTON : K_LOCK_BUTTON)), lockBtn -> {
            if (this.serverOptions.locked()) {
                this.serverOptions = this.serverOptions.butUnlocked();
                this.changed = true;
                this.toggleWorldButtons(false);
                return;
            }
            class_410 scr = new class_410(shouldLock -> {
                if (shouldLock) {
                    this.serverOptions = this.serverOptions.butLocked();
                    this.changed = true;
                    this.toggleWorldButtons(true);
                }
                this.field_22787.method_1507((class_437)this);
            }, (class_2561)class_2561.method_43471((String)K_LOCK_SCREEN_TITLE), (class_2561)class_2561.method_43471((String)K_LOCK_SCREEN_MESSAGE));
            this.field_22787.method_1507((class_437)scr);
            scr.method_2125(10);
        }).method_46431();
        this.field_51824.method_20407((class_339)lockButton, null);
        this.lockButton = lockButton;
    }

    public void method_25393() {
        super.method_25393();
        if (this.lockButton != null) {
            this.lockButton.field_22763 = this.ingame && (!this.serverOptions.locked() || this.serverOptions.locked() && this.field_22787.method_74187()) && !Networking.serverEnforced;
        }
    }

    public void method_25419() {
        this.save();
        Main.CONFIG.configureInstance();
        super.method_25419();
    }

    protected void save() {
        if (this.changed) {
            Main.CONFIG.setServerOptions(Networking.uniqueId, this.serverOptions);
            ConfigFile.save(Main.CONFIG);
        }
    }

    private void toggleWorldButtons(boolean locked) {
        class_5250 lockButtonText;
        boolean active;
        this.effectButton.field_22763 = active = this.ingame && !locked && (!Networking.serverEnforced || Networking.isOpForBypass);
        this.worldCreativeBypassButton.field_22763 = active;
        this.worldSpectatorBypassButton.field_22763 = active;
        class_5250 class_52502 = Networking.serverEnforced ? class_2561.method_43471((String)K_LOCK_BUTTON_SERVER_ENFORCED) : (lockButtonText = locked ? class_2561.method_43471((String)K_UNLOCK_BUTTON) : class_2561.method_43471((String)K_LOCK_BUTTON));
        class_7919 lockButtonTooltip = Networking.serverEnforced ? class_7919.method_47407((class_2561)class_2561.method_43471((String)K_LOCK_BUTTON_SERVER_ENFORCED_TOOLTIP)) : (locked ? class_7919.method_47407((class_2561)class_2561.method_43471((String)K_UNLOCK_BUTTON_TOOLTIP)) : null);
        this.lockButton.method_25355((class_2561)lockButtonText);
        this.lockButton.method_47400(lockButtonTooltip);
    }
}

