/*
 * Decompiled with CFR 0.152.
 */
package hibi.blind_me.server;

import hibi.blind_me.config.ServerEffect;
import hibi.blind_me.server.Main;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public ServerEffect effect = ServerEffect.BLINDNESS;
    public boolean opsBypass = true;
    public boolean creativeBypass = false;
    public boolean spectatorBypass = true;
    private static final String PATH = FabricLoader.getInstance().getConfigDir().toAbsolutePath().resolve("blindme.server.properties").toString();
    private static final String DEFAULT_CONFIG_FILE = "# The selected vision-impairing effect for this server.\n# Can be one of \"blindness\" or \"darkness\".\neffect = blindness\n# When clients without BlindMe log in, they will be given that effect purely at\n# the network level, but the real player in the world will not have it. When a\n# client with BlindMe logs in, it will enforce the chosen effect, since it\n# employs quality-of-life improvements, such as the ability to sprint when\n# blinded, and visual strobe reduction.\n\n# Controls whether players in creative mode have their effect removed.\n# - Only available for clients using BlindMe. The server-side fallback system\n#   is relatively primitive.\n# Can be one of \"true\" or \"false\".\ncreative_bypass = false\n\n# Controls whether players in spectator mode have their effect removed.\n# - Only available for clients using BlindMe. The server-side fallback system\n#   is relatively primitive.\n# Can be one of \"true\" or \"false\".\nspectators_bypass = true\n\n# Controls whether operators using BlindMe can change their settings.\n# - Applicable to players with permission level 2 or higher: game masters,\n#   administrators and owners.\n# - Only available for clients using BlindMe. The server-side fallback system\n#   is relatively primitive.\n# Can be one of \"true\" or \"false\".\nops_bypass = false\n";

    public static Config load() throws IOException {
        Object object;
        BufferedReader reader = new BufferedReader(new FileReader(PATH));
        try {
            Properties props = new Properties();
            props.load(reader);
            Config config = new Config();
            config.effect = switch (props.getProperty("effect").toLowerCase()) {
                case "blindness" -> ServerEffect.BLINDNESS;
                case "darkness" -> ServerEffect.BLINDNESS;
                default -> throw new IllegalArgumentException("Bad effect in config file, expected \"blindness\" or \"darkness\"");
            };
            config.creativeBypass = switch (props.getProperty("creative_bypass").toLowerCase()) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new IllegalArgumentException("Bad creative bypass in config file, expected \"true\" or \"false\"");
            };
            config.spectatorBypass = switch (props.getProperty("spectators_bypass").toLowerCase()) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new IllegalArgumentException("Bad spectator bypass in config file, expected \"true\" or \"false\"");
            };
            config.opsBypass = switch (props.getProperty("ops_bypass").toLowerCase()) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new IllegalArgumentException("Bad OPs bypass in config file, expected \"true\" or \"false\"");
            };
            object = config;
        }
        catch (Throwable props) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    props.addSuppressed(throwable);
                }
                throw props;
            }
            catch (FileNotFoundException e) {
                Main.LOGGER.warn("Config file not found, creating a new file and using default configuration.");
                Config config = new Config();
                config.save();
                return config;
            }
        }
        reader.close();
        return object;
    }

    private void save() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(PATH));){
            writer.write(DEFAULT_CONFIG_FILE);
        }
        catch (Exception e) {
            Main.LOGGER.error("Could not save the config file", (Throwable)e);
        }
    }
}

