/*
 * Decompiled with CFR 0.152.
 */
package com.gentra.mobsdropmeat;

import com.gentra.mobsdropmeat.Config;
import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="mobsdropmeat")
public class MobsDropMeat {
    public static final String MODID = "mobsdropmeat";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"mobsdropmeat");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mobsdropmeat");
    public static final DeferredItem<Item> MEAT = ITEMS.register("meat", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build())));
    public static final DeferredItem<Item> COOKED_MEAT = ITEMS.register("cooked_meat", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).build())));

    public MobsDropMeat(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("MEAT item registered: {}", (Object)MEAT.getId());
        LOGGER.info("COOKED_MEAT item registered: {}", (Object)COOKED_MEAT.getId());
        LOGGER.info("Looking for smelting recipe: mobsdropmeat:meat -> mobsdropmeat:cooked_meat");
        LOGGER.info("MobsDropMeat mod loaded successfully!");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept(MEAT);
            event.accept(COOKED_MEAT);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityType entityType = event.getEntity().getType();
        boolean shouldDropMeat = false;
        if (entityType == EntityType.FOX && ((Boolean)Config.ENABLE_FOX_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.WOLF && ((Boolean)Config.ENABLE_WOLF_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.LLAMA && ((Boolean)Config.ENABLE_LLAMA_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.HORSE && ((Boolean)Config.ENABLE_HORSE_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.GOAT && ((Boolean)Config.ENABLE_GOAT_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.DONKEY && ((Boolean)Config.ENABLE_DONKEY_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.RABBIT && ((Boolean)Config.ENABLE_RABBIT_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.POLAR_BEAR && ((Boolean)Config.ENABLE_POLAR_BEAR_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.OCELOT && ((Boolean)Config.ENABLE_OCELOT_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.MULE && ((Boolean)Config.ENABLE_MULE_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.SQUID && ((Boolean)Config.ENABLE_SQUID_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.GLOW_SQUID && ((Boolean)Config.ENABLE_GLOW_SQUID_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.BAT && ((Boolean)Config.ENABLE_BAT_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.SPIDER && ((Boolean)Config.ENABLE_SPIDER_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.CAVE_SPIDER && ((Boolean)Config.ENABLE_CAVE_SPIDER_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.CREEPER && ((Boolean)Config.ENABLE_CREEPER_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.PHANTOM && ((Boolean)Config.ENABLE_PHANTOM_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.RAVAGER && ((Boolean)Config.ENABLE_RAVAGER_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.STRIDER && ((Boolean)Config.ENABLE_STRIDER_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        } else if (entityType == EntityType.GHAST && ((Boolean)Config.ENABLE_GHAST_DROPS.get()).booleanValue()) {
            shouldDropMeat = true;
        }
        if (shouldDropMeat) {
            ItemStack meatStack = new ItemStack((ItemLike)MEAT.get());
            ItemEntity meatEntity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), meatStack);
            event.getDrops().add(meatEntity);
        }
    }
}

