/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems.displaymanager;

import de.deinname.mysticgems.MysticGems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GemDisplayManager {
    private final MysticGems plugin;
    private final Map<UUID, ArmorStand> activeDisplays = new HashMap<UUID, ArmorStand>();

    public GemDisplayManager(MysticGems plugin) {
        this.plugin = plugin;
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    GemDisplayManager.this.updateDisplay(player);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 10L);
    }

    private void updateDisplay(Player player) {
        ItemStack held = player.getInventory().getItemInMainHand();
        if (this.isGem(held)) {
            if (!this.activeDisplays.containsKey(player.getUniqueId())) {
                ArmorStand stand = this.spawnFloatingGem(player, held);
                this.activeDisplays.put(player.getUniqueId(), stand);
            } else {
                ArmorStand stand = this.activeDisplays.get(player.getUniqueId());
                stand.teleport(player.getLocation().add(0.0, 2.2, 0.0));
            }
        } else if (this.activeDisplays.containsKey(player.getUniqueId())) {
            this.activeDisplays.get(player.getUniqueId()).remove();
            this.activeDisplays.remove(player.getUniqueId());
        }
    }

    private ArmorStand spawnFloatingGem(Player player, ItemStack gem) {
        Location loc = player.getLocation().add(0.0, 2.2, 0.0);
        ArmorStand stand = (ArmorStand)player.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        stand.setInvisible(true);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setHelmet(gem.clone());
        return stand;
    }

    private boolean isGem(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "gem_type");
        return meta.getPersistentDataContainer().has(key, PersistentDataType.STRING);
    }

    public void cleanup(Player player) {
        ArmorStand stand = this.activeDisplays.remove(player.getUniqueId());
        if (stand != null) {
            stand.remove();
        }
    }
}

