/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems.listener;

import de.deinname.mysticgems.items.GemItems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GemAbilityListener
implements Listener {
    private final GemItems gemItems;
    private final JavaPlugin plugin;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public GemAbilityListener(GemItems gemItems, JavaPlugin plugin) {
        this.gemItems = gemItems;
        this.plugin = plugin;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String displayName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        UUID playerId = player.getUniqueId();
        int cooldownSeconds = this.plugin.getConfig().getInt("cooldown-seconds", 7);
        long cooldownTime = (long)cooldownSeconds * 1000L;
        if (this.cooldowns.containsKey(playerId) && System.currentTimeMillis() - this.cooldowns.get(playerId) < cooldownTime) {
            long secondsLeft = (cooldownTime - (System.currentTimeMillis() - this.cooldowns.get(playerId))) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "Du musst noch " + secondsLeft + " Sekunden warten!");
            return;
        }
        switch (displayName.toLowerCase()) {
            case "fire gem": {
                this.fireGemAbility(player);
                break;
            }
            case "water gem": {
                this.waterGemAbility(player);
                break;
            }
            case "earth gem": {
                this.earthGemAbility(player);
                break;
            }
            case "air gem": {
                this.airGemAbility(player);
                break;
            }
            case "lightning gem": {
                this.lightningGemAbility(player);
                break;
            }
            case "shadow gem": {
                this.shadowGemAbility(player);
                break;
            }
            default: {
                return;
            }
        }
        this.cooldowns.put(playerId, System.currentTimeMillis());
    }

    private void fireGemAbility(Player player) {
        ((Fireball)player.launchProjectile(Fireball.class)).setIsIncendiary(true);
        this.spawnEffect(player, Particle.FLAME, Sound.ENTITY_BLAZE_SHOOT);
    }

    private void waterGemAbility(Player player) {
        int duration = this.plugin.getConfig().getInt("effect-duration-seconds.water", 10) * 20;
        player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, duration, 0));
        this.spawnEffect(player, Particle.BUBBLE_COLUMN_UP, Sound.WEATHER_RAIN);
    }

    private void earthGemAbility(Player player) {
        float strength = (float)this.plugin.getConfig().getDouble("explosion-strength-earth", 2.0);
        player.getWorld().createExplosion(player.getLocation(), strength, false, false);
        this.spawnEffect(player, Particle.CAMPFIRE_COSY_SMOKE, Sound.ENTITY_GENERIC_EXPLODE);
    }

    private void airGemAbility(Player player) {
        int levitation = this.plugin.getConfig().getInt("effect-duration-seconds.air-levitation", 5) * 20;
        int speed = this.plugin.getConfig().getInt("effect-duration-seconds.air-speed", 10) * 20;
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, levitation, 0));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, speed, 1));
        this.spawnEffect(player, Particle.CLOUD, Sound.ENTITY_PHANTOM_FLAP);
    }

    private void lightningGemAbility(Player player) {
        player.getWorld().strikeLightningEffect(player.getLocation());
        this.spawnEffect(player, Particle.DRAGON_BREATH, Sound.ENTITY_LIGHTNING_BOLT_IMPACT);
    }

    private void shadowGemAbility(Player player) {
        int distance = this.plugin.getConfig().getInt("shadow-teleport-distance", 5);
        int duration = this.plugin.getConfig().getInt("effect-duration-seconds.shadow-invisibility", 5) * 20;
        Location newLoc = player.getLocation().add(player.getLocation().getDirection().multiply(distance));
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation(), 50, 1.0, 1.0, 1.0, 0.1);
        player.teleport(newLoc);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, duration, 0));
        newLoc.getWorld().spawnParticle(Particle.PORTAL, newLoc, 50, 1.0, 1.0, 1.0, 0.1);
        player.playSound(newLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
    }

    private void spawnEffect(Player player, Particle particle, Sound sound) {
        int amount = this.plugin.getConfig().getInt("particles-per-effect", 30);
        player.getWorld().spawnParticle(particle, player.getLocation(), amount, 0.5, 1.0, 0.5, 0.05);
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }
}

