/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems;

import de.deinname.mysticgems.commands.GemCommand;
import de.deinname.mysticgems.items.GemItems;
import de.deinname.mysticgems.listener.GemAbilityListener;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MysticGems
extends JavaPlugin
implements Listener {
    private static MysticGems instance;
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private final long cooldownTime = 7000L;

    public void onEnable() {
        this.saveDefaultConfig();
        GemItems gemItems = new GemItems();
        this.getServer().getPluginManager().registerEvents((Listener)new GemAbilityListener(gemItems, this), (Plugin)this);
        instance = this;
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getCommand("gem") != null) {
            this.getCommand("gem").setExecutor((CommandExecutor)new GemCommand());
        }
        Bukkit.getLogger().info("MysticGems wurde aktiviert!");
    }

    public void onDisable() {
        Bukkit.getLogger().info("MysticGems wurde deaktiviert.");
    }

    public static MysticGems getInstance() {
        return instance;
    }

    @EventHandler
    public void onPlayerUseGem(PlayerInteractEvent event) {
        long lastUsed;
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(playerId) && now - (lastUsed = this.cooldowns.get(playerId).longValue()) < 7000L) {
            long secondsLeft = (7000L - (now - lastUsed)) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "Bitte warte noch " + secondsLeft + " Sekunden, bevor du den Gem erneut benutzt.");
            event.setCancelled(true);
            return;
        }
        if (item.isSimilar(GemItems.getFireGem())) {
            event.setCancelled(true);
            this.fireGemAbility(player);
        } else if (item.isSimilar(GemItems.getWaterGem())) {
            event.setCancelled(true);
            this.waterGemAbility(player);
        } else if (item.isSimilar(GemItems.getEarthGem())) {
            event.setCancelled(true);
            this.earthGemAbility(player);
        } else if (item.isSimilar(GemItems.getAirGem())) {
            event.setCancelled(true);
            this.airGemAbility(player);
        } else if (item.isSimilar(GemItems.getLightningGem())) {
            event.setCancelled(true);
            this.lightningGemAbility(player);
        } else if (item.isSimilar(GemItems.getShadowGem())) {
            event.setCancelled(true);
            this.shadowGemAbility(player);
        } else {
            return;
        }
        this.cooldowns.put(playerId, now);
    }

    private void fireGemAbility(Player player) {
        player.launchProjectile(Fireball.class);
        player.sendMessage(String.valueOf(ChatColor.RED) + "Feuer-Gem aktiviert!");
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.FLAME, player.getLocation().add(0.0, 1.0, 0.0), 20);
    }

    private void waterGemAbility(Player player) {
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Wasser-Gem aktiviert! Du kannst jetzt 30 Sekunden unter Wasser atmen.");
        player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 200, 0));
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BUCKET_FILL, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.BUBBLE, player.getLocation(), 20);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            player.removePotionEffect(PotionEffectType.WATER_BREATHING);
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Wasser-Gem Effekt vorbei.");
        }, 600L);
    }

    private void earthGemAbility(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Erde-Gem aktiviert! Du hast jetzt Absorption 2 f\u00fcr 15 Sekunden.");
        player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 300, 1));
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, player.getLocation(), 20);
    }

    private void airGemAbility(Player player) {
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "Luft-Gem aktiviert! Levitation, Slow Falling und Speed f\u00fcr 10 Sekunden.");
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 200, 0));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 200, 0));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, 0));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PHANTOM_FLAP, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 20);
    }

    private void lightningGemAbility(Player player) {
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Blitz-Gem aktiviert! Blitzschlag an deiner Position!");
        Location loc = player.getLocation();
        player.getWorld().strikeLightningEffect(loc);
        player.getWorld().playSound(loc, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, loc, 30);
    }

    private void shadowGemAbility(Player player) {
        player.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Schatten-Gem aktiviert! Du teleportierst dich 10 Bl\u00f6cke vorw\u00e4rts.");
        Location loc = player.getLocation();
        Location target = loc.add(loc.getDirection().multiply(10));
        player.teleport(target);
        player.getWorld().playSound(target, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.PORTAL, target, 30);
    }
}

