/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems.tracker;

import de.deinname.mysticgems.MysticGems;
import de.deinname.mysticgems.items.GemFactory;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KillTracker
implements Listener {
    private final MysticGems plugin;

    public KillTracker(MysticGems plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player killer = event.getEntity().getKiller();
        if (killer == null || !(entity instanceof Blaze)) {
            return;
        }
        UUID uuid = killer.getUniqueId();
        File file = new File(this.plugin.getDataFolder(), "progress.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        int current = config.getInt(String.valueOf(uuid) + ".fire_kills", 0);
        config.set(String.valueOf(uuid) + ".fire_kills", (Object)(++current));
        if (current == 100) {
            killer.getInventory().addItem(new ItemStack[]{GemFactory.createFireGem()});
            killer.sendMessage("\u00a76Du hast den Fire-Gem erhalten!");
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

