/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems.tracker;

import de.deinname.mysticgems.MysticGems;
import de.deinname.mysticgems.items.GemFactory;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SwimTracker
implements Listener {
    private final MysticGems plugin;

    public SwimTracker(MysticGems plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Block headBlock = player.getLocation().getBlock();
        if (headBlock.getType() != Material.WATER && headBlock.getType() != Material.BUBBLE_COLUMN) {
            return;
        }
        UUID uuid = player.getUniqueId();
        File file = new File(this.plugin.getDataFolder(), "progress.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        double current = config.getDouble(String.valueOf(uuid) + ".water_distance", 0.0);
        double delta = event.getFrom().distance(event.getTo());
        config.set(String.valueOf(uuid) + ".water_distance", (Object)(current += delta));
        if (current >= 1000.0 && !config.getBoolean(String.valueOf(uuid) + ".water_gem_received", false)) {
            player.getInventory().addItem(new ItemStack[]{GemFactory.createWaterGem()});
            player.sendMessage("\u00a7bDu hast den Water-Gem erhalten!");
            config.set(String.valueOf(uuid) + ".water_gem_received", (Object)true);
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

