/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems.listener;

import de.deinname.mysticgems.MysticGems;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GemListener
implements Listener {
    private final MysticGems plugin;

    public GemListener(MysticGems plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        List drops = event.getDrops();
        ArrayList<ItemStack> gemDrops = new ArrayList<ItemStack>();
        for (ItemStack item : new ArrayList(drops)) {
            if (!this.isGem(item)) continue;
            gemDrops.add(item);
            drops.remove(item);
        }
        if (!gemDrops.isEmpty()) {
            Location spawn = Bukkit.getWorld((String)"world").getSpawnLocation();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (ItemStack gem : gemDrops) {
                    spawn.getWorld().dropItemNaturally(spawn, gem);
                }
            }, 20L);
        }
    }

    private boolean isGem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.hasDisplayName() && meta.getDisplayName().contains("Gem");
    }
}

