/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.mysticgems.listener;

import de.deinname.mysticgems.MysticGems;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GemProtectionListener
implements Listener {
    private final MysticGems plugin;

    public GemProtectionListener(MysticGems plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity victim = event.getEntity();
        if (!(damager instanceof Player) || !(victim instanceof Player)) {
            return;
        }
        Player attacker = (Player)damager;
        Player target = (Player)victim;
        if (this.hasSameGemInHand(attacker, target)) {
            event.setCancelled(true);
            attacker.sendMessage("Du kannst diesen Spieler nicht angreifen, da er denselben Gem tr\u00e4gt.");
        }
    }

    private boolean hasSameGemInHand(Player p1, Player p2) {
        ItemStack item1 = p1.getInventory().getItemInMainHand();
        ItemStack item2 = p2.getInventory().getItemInMainHand();
        if (item1 == null || item2 == null) {
            return false;
        }
        if (!item1.hasItemMeta() || !item2.hasItemMeta()) {
            return false;
        }
        ItemMeta meta1 = item1.getItemMeta();
        ItemMeta meta2 = item2.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "gem_type");
        String type1 = (String)meta1.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        String type2 = (String)meta2.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        return type1 != null && type1.equals(type2);
    }
}

