/*
 * Decompiled with CFR 0.152.
 */
package live.gunnablescum.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.livinglemming.VillagerPickup;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import live.gunnablescum.configuration.ConfigurationObject;

class Configuration {
    List<ConfigurationObject<?>> sections = new ArrayList();

    private static void loadDefaults(Configuration configuration) {
        ConfigurationObject boolSection = new ConfigurationObject();
        boolSection.values.put("enable_villager_pickup", true);
        boolSection.values.put("allow_villager_rename_with_anvil", false);
        configuration.sections.add(boolSection);
    }

    private static void createConfig(Gson gson, File file) throws IOException {
        VillagerPickup.LOGGER.info("Creating configuration file: {}", (Object)file.getAbsolutePath());
        Configuration configuration = new Configuration();
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        Configuration.loadDefaults(configuration);
        writer.write(gson.toJson((Object)configuration));
        writer.close();
    }

    public static Configuration loadConfig(File file) {
        VillagerPickup.LOGGER.info("Loading configuration file: {}", (Object)file.getAbsolutePath());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (!file.exists()) {
                Configuration.createConfig(gson, file);
            }
            FileReader reader = new FileReader(file);
            return (Configuration)gson.fromJson((Reader)reader, Configuration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

