/*
 * Decompiled with CFR 0.152.
 */
package live.gunnablescum.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import live.gunnablescum.configuration.Configuration;
import live.gunnablescum.configuration.ConfigurationObject;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigurationHandler {
    private static Configuration config = Configuration.loadConfig(ConfigurationHandler.getConfigFile());

    public static void reloadConfig() {
        config = Configuration.loadConfig(ConfigurationHandler.getConfigFile());
    }

    public static boolean getBoolean(String key) {
        for (ConfigurationObject<?> section : ConfigurationHandler.config.sections) {
            if (!(section instanceof ConfigurationObject) || !(section.values.get(key) instanceof Boolean)) continue;
            return (Boolean)section.values.get(key);
        }
        return false;
    }

    public static void setBoolean(String key, boolean value) {
        for (ConfigurationObject<?> section : ConfigurationHandler.config.sections) {
            if (!(section instanceof ConfigurationObject) || !(section.values.get(key) instanceof Boolean)) continue;
            section.values.put(key, value);
        }
    }

    private static File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), "villager-pickup.json");
    }

    public static void saveConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter writer = new FileWriter(ConfigurationHandler.getConfigFile());
            writer.write(gson.toJson((Object)config));
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

