/*
 * Decompiled with CFR 0.152.
 */
package live.gunnablescum.villagerpickup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import live.gunnablescum.villagerpickup.commands.VillagerPickupCommand;
import live.gunnablescum.villagerpickup.configuration.ConfigurationHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class CommonClass {
    public static void initCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        VillagerPickupCommand.register(dispatcher);
    }

    public static ItemStack convertVillagerToItemStack(Player player, Entity entity) {
        MerchantOffers list;
        if (player.level().isClientSide()) {
            return null;
        }
        if (!player.isCrouching()) {
            return null;
        }
        if (!ConfigurationHandler.getBoolean("enable_villager_pickup")) {
            return null;
        }
        if (!(entity instanceof Villager)) {
            return null;
        }
        Villager villager = (Villager)entity;
        TagValueOutput nbt = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)villager.level().registryAccess());
        villager.addAdditionalSaveData((ValueOutput)nbt);
        nbt.discard("sleeping_pos");
        SpawnEggItem spawnEgg = SpawnEggItem.byId((EntityType)EntityType.VILLAGER);
        if (spawnEgg == null) {
            return null;
        }
        ItemStack spawnEggStack = new ItemStack((ItemLike)spawnEgg);
        Component healthText = CommonClass.createHealthText(villager.getHealth(), villager.getMaxHealth());
        MutableComponent professionText = CommonClass.createLoreText(Component.literal((String)("Profession: [" + villager.getVillagerData().profession().getRegisteredName() + "]")));
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>(List.of(healthText, professionText));
        if (villager.getVillagerData().level() > 1) {
            lore.add(CommonClass.createLoreText(Component.literal((String)("Level: [" + villager.getVillagerData().level() + "]"))));
        }
        if (!(list = villager.getOffers()).isEmpty()) {
            lore.add(Component.literal((String)""));
            lore.add(CommonClass.createLoreText(Component.literal((String)"Trades:")));
        }
        for (MerchantOffer offer : list) {
            lore.add((MutableComponent)CommonClass.convertTradeToText(offer));
        }
        ItemLore loreData = new ItemLore(lore);
        DataComponentPatch.Builder changes = DataComponentPatch.builder().set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)EntityType.VILLAGER, (CompoundTag)nbt.buildResult())).set(DataComponents.LORE, (Object)loreData);
        if (villager.hasCustomName()) {
            changes.set(DataComponents.CUSTOM_NAME, (Object)villager.getCustomName());
        }
        changes.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(List.of(), List.of(), List.of(villager.getVillagerData().profession().getRegisteredName()), List.of()));
        spawnEggStack.applyComponentsAndValidate(changes.build());
        return spawnEggStack;
    }

    @NotNull
    private static Component convertTradeToText(MerchantOffer offer) {
        ItemStack firstBuyItem = offer.getItemCostA().itemStack();
        Optional secondBuyItem = offer.getItemCostB();
        ItemStack sellItem = offer.getResult();
        MutableComponent toDisplay = Component.literal((String)(firstBuyItem.getCount() + "x ")).append((Component)Component.translatable((String)firstBuyItem.getItem().getDescriptionId()));
        if (secondBuyItem.isPresent()) {
            ItemStack secondBuyItemStack = ((ItemCost)secondBuyItem.get()).itemStack();
            toDisplay.append(" + ").append(secondBuyItemStack.getCount() + "x ").append((Component)Component.translatable((String)secondBuyItemStack.getItem().getDescriptionId()));
        }
        toDisplay.append(" = " + sellItem.getCount() + "x ").append((Component)Component.translatable((String)sellItem.getItem().getDescriptionId()));
        return CommonClass.createLoreText(toDisplay);
    }

    private static Component createHealthText(float health, float maxHealth) {
        char fullHeart = '\u2764';
        String damagedHeart = "\ud83d\udc94";
        int fullHearts = (int)Math.floor(health);
        int halfHearts = (int)Math.ceil(health - (float)fullHearts);
        MutableComponent fullHeartText = Component.literal((String)String.valueOf(fullHeart).repeat(fullHearts)).withColor(0xFF0000);
        MutableComponent halfHeartText = Component.literal((String)damagedHeart.repeat(halfHearts)).withColor(0xFF0000);
        MutableComponent missingHeartText = Component.literal((String)String.valueOf(fullHeart).repeat((int)Math.ceil(maxHealth - health))).withColor(0x808080);
        return CommonClass.createLoreText(Component.literal((String)"Health: ")).append((Component)fullHeartText).append((Component)halfHeartText).append((Component)missingHeartText);
    }

    private static MutableComponent createLoreText(MutableComponent inputText) {
        return inputText.setStyle(inputText.getStyle().withItalic(Boolean.valueOf(false)).withColor(0x808080));
    }

    public static Component getStatusOfBool(String key, String displayName) {
        boolean value = ConfigurationHandler.getBoolean(key);
        return Component.literal((String)(displayName + ": " + value)).withStyle(value ? ChatFormatting.GREEN : ChatFormatting.RED).append((Component)Component.literal((String)(value ? "Enabled" : "Disabled")));
    }
}

