/*
 * Decompiled with CFR 0.152.
 */
package live.gunnablescum.villagerpickup.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import live.gunnablescum.villagerpickup.CommonClass;
import live.gunnablescum.villagerpickup.configuration.ConfigurationHandler;
import live.gunnablescum.villagerpickup.configuration.ConfigurationScreenHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;

public class VillagerPickupCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"villager-pickup").then(Commands.literal((String)"status").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Villager-Pickup Status:").withStyle(ChatFormatting.GOLD));
            ((CommandSourceStack)context.getSource()).sendSystemMessage(CommonClass.getStatusOfBool("enable_villager_pickup", "Villager Pickup"));
            ((CommandSourceStack)context.getSource()).sendSystemMessage(CommonClass.getStatusOfBool("allow_villager_rename_with_anvil", "Villager Anvil Renaming"));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.hasPermission(4))).executes(context -> {
            ConfigurationHandler.reloadConfig();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Config Reload successful.").withStyle(ChatFormatting.GREEN), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"config-gui").requires(source -> source.hasPermission(4))).executes(context -> {
            if (!((CommandSourceStack)context.getSource()).isPlayer()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"This command can only be executed by a player.").withStyle(ChatFormatting.RED), false);
                return 0;
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Editing Villager-Pickup Config...").withStyle(ChatFormatting.GRAY), true);
            player.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, playerEntity) -> new ConfigurationScreenHandler(syncId, playerInventory), (Component)Component.literal((String)"Villager-Pickup Config")));
            return 1;
        })));
    }
}

