/*
 * Decompiled with CFR 0.152.
 */
package live.gunnablescum.villagerpickup.configuration;

import java.util.ArrayList;
import java.util.List;
import live.gunnablescum.villagerpickup.configuration.ConfigurationHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;

public class ConfigurationScreenHandler
extends ChestMenu {
    public ConfigurationScreenHandler(int syncId, Inventory playerInventory) {
        super(MenuType.GENERIC_9x3, syncId, playerInventory, (Container)new SimpleContainer(27), 3);
        this.updateInventory();
    }

    private void updateInventory() {
        ItemStack[] content = new ItemStack[27];
        for (int i = 0; i < content.length; ++i) {
            content[i] = Items.LIGHT_GRAY_STAINED_GLASS_PANE.getDefaultInstance();
            DataComponentPatch.Builder changes = DataComponentPatch.builder();
            changes.set(DataComponents.CUSTOM_NAME, (Object)Component.nullToEmpty((String)""));
            content[i].applyComponentsAndValidate(changes.build());
        }
        content[11] = Items.VILLAGER_SPAWN_EGG.getDefaultInstance();
        DataComponentPatch.Builder changes = DataComponentPatch.builder();
        changes.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Villager Pickup").withStyle(ChatFormatting.GOLD));
        changes.set(DataComponents.LORE, (Object)new ItemLore(this.getStatusLore(ConfigurationHandler.getBoolean("enable_villager_pickup"), "Toggle this option to enable or disable Villager Pickup.")));
        content[11].applyComponentsAndValidate(changes.build());
        content[15] = Items.ANVIL.getDefaultInstance();
        changes = DataComponentPatch.builder();
        changes.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Allow Villager Rename with Anvil").withStyle(ChatFormatting.GOLD));
        changes.set(DataComponents.LORE, (Object)new ItemLore(this.getStatusLore(ConfigurationHandler.getBoolean("allow_villager_rename_with_anvil"), "Toggle this option to enable or disable", "renaming Villagers in an Anvil.")));
        content[15].applyComponentsAndValidate(changes.build());
        for (int i = 0; i < content.length; ++i) {
            ((Slot)this.slots.get(i)).set(content[i]);
        }
    }

    private List<Component> getStatusLore(boolean status, String ... loreText) {
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String str : loreText) {
            lore.add((Component)Component.literal((String)str).withStyle(ChatFormatting.GRAY));
        }
        lore.add((Component)Component.literal((String)"Status:").withStyle(ChatFormatting.GRAY));
        MutableComponent enabled = Component.literal((String)"Enabled").withStyle(ChatFormatting.GREEN);
        enabled.withStyle(enabled.getStyle().withUnderlined(Boolean.valueOf(status)));
        lore.add((Component)enabled);
        MutableComponent disabled = Component.literal((String)"Disabled").withStyle(ChatFormatting.RED);
        disabled.withStyle(disabled.getStyle().withUnderlined(Boolean.valueOf(!status)));
        lore.add((Component)disabled);
        return lore;
    }

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (Player operator : serverPlayer.level().getServer().getPlayerList().getPlayers()) {
                if (operator.getPermissionLevel() != 4) continue;
                operator.displayClientMessage((Component)Component.literal((String)"[").append(player.getDisplayName()).append(": Changed Villager-Pickup Config]").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))), false);
            }
        }
        ConfigurationHandler.saveConfig();
        super.removed(player);
    }

    public void clicked(int slotId, int button, ClickType actionType, Player player) {
        if (player.getPermissionLevel() != 4) {
            return;
        }
        switch (slotId) {
            case 11: {
                ConfigurationHandler.setBoolean("enable_villager_pickup", !ConfigurationHandler.getBoolean("enable_villager_pickup"));
                break;
            }
            case 15: {
                ConfigurationHandler.setBoolean("allow_villager_rename_with_anvil", !ConfigurationHandler.getBoolean("allow_villager_rename_with_anvil"));
            }
        }
        this.updateInventory();
    }
}

