/*
 * Decompiled with CFR 0.152.
 */
package live.gunnablescum.villagerpickup.listeners;

import live.gunnablescum.villagerpickup.CommonClass;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class RightClickEventListener {
    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        InteractionHand hand = event.getHand();
        if (event.getTarget().getType() != EntityType.VILLAGER) {
            event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            return;
        }
        if (!player.isCrouching() && player.getItemInHand(hand).getItem() == Items.VILLAGER_SPAWN_EGG) {
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            event.setCanceled(true);
            return;
        }
        ItemStack spawnEgg = CommonClass.convertVillagerToItemStack(player, entity);
        if (spawnEgg == null) {
            event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            return;
        }
        if (player.getInventory().getFreeSlot() != -1) {
            player.getInventory().add(spawnEgg);
        } else {
            player.drop(spawnEgg, true);
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
        event.setCanceled(true);
    }
}

