/*
 * Decompiled with CFR 0.152.
 */
package com.github.p1k0chu.mcmod.bac_tracker;

import com.github.p1k0chu.mcmod.bac_tracker.TrackerCommand;
import com.github.p1k0chu.mcmod.bac_tracker.data.AdvancementData;
import com.github.p1k0chu.mcmod.bac_tracker.data.ItemData;
import com.github.p1k0chu.mcmod.bac_tracker.data.ScoreboardData;
import com.github.p1k0chu.mcmod.bac_tracker.data.StatData;
import com.github.p1k0chu.mcmod.bac_tracker.event.AdvancementUpdatedCallback;
import com.github.p1k0chu.mcmod.bac_tracker.event.ScoreboardUpdatedCallback;
import com.github.p1k0chu.mcmod.bac_tracker.event.StatUpdatedCallback;
import com.github.p1k0chu.mcmod.bac_tracker.settings.Settings;
import com.github.p1k0chu.mcmod.bac_tracker.utils.AdvancementProgressGetter;
import com.github.p1k0chu.mcmod.bac_tracker.utils.ComparingType;
import com.github.p1k0chu.mcmod.bac_tracker.utils.Utils;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchGetValuesResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_5218;
import net.minecraft.class_8779;
import net.minecraft.class_9011;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0097\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010!\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0004\b!\u0010\"J9\u0010+\u001a\u00020\n2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010*\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b-\u0010\u0003J\r\u0010.\u001a\u00020\u0014\u00a2\u0006\u0004\b.\u0010/JU\u00107\u001a\u0010\u0012\f\u0012\n 6*\u0004\u0018\u00010505002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\f002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\f002\f\u00104\u001a\b\u0012\u0004\u0012\u00020\f00H\u0002\u00a2\u0006\u0004\b7\u00108J?\u0010;\u001a\u00020\n2\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f002\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f002\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f00H\u0002\u00a2\u0006\u0004\b;\u0010<J'\u0010?\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b?\u0010@J-\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\f0C2\u0006\u0010B\u001a\u00020A2\u0006\u0010>\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bD\u0010EJ'\u0010F\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bF\u0010@J/\u0010G\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010C2\u0006\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010K\u001a\u00020\n2\u0006\u0010J\u001a\u00020IH\u0002\u00a2\u0006\u0004\bK\u0010LJ'\u0010Q\u001a\u00020\n2\u0006\u0010M\u001a\u00020\f2\u0006\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bQ\u0010RJ\u001f\u0010S\u001a\u00020\n2\u0006\u0010M\u001a\u00020\f2\u0006\u0010O\u001a\u00020NH\u0002\u00a2\u0006\u0004\bS\u0010TJ\u001d\u0010U\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f00H\u0002\u00a2\u0006\u0004\bU\u0010VJ+\u0010W\u001a\u00020\n2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\f002\f\u00104\u001a\b\u0012\u0004\u0012\u00020\f00H\u0002\u00a2\u0006\u0004\bW\u0010XJ\u001f\u0010[\u001a\u0004\u0018\u00010Z2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020500H\u0002\u00a2\u0006\u0004\b[\u0010\\J+\u0010^\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f00\u0018\u0001002\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\f00H\u0002\u00a2\u0006\u0004\b^\u0010_J\u0019\u0010a\u001a\u0004\u0018\u0001052\u0006\u0010`\u001a\u00020\fH\u0002\u00a2\u0006\u0004\ba\u0010bR\u0014\u0010c\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u0014\u0010e\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\be\u0010dR\u0017\u0010g\u001a\u00020f8\u0006\u00a2\u0006\f\n\u0004\bg\u0010h\u001a\u0004\bi\u0010jR\u0017\u0010l\u001a\u00020k8\u0006\u00a2\u0006\f\n\u0004\bl\u0010m\u001a\u0004\bn\u0010oR\u0017\u0010q\u001a\u00020p8\u0006\u00a2\u0006\f\n\u0004\bq\u0010r\u001a\u0004\bs\u0010tR\u0014\u0010v\u001a\u00020u8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bv\u0010wR$\u0010y\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020#\u0018\u00010x8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\by\u0010zR$\u0010{\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0018\u00010x8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b{\u0010zR$\u0010}\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020|\u0018\u00010x8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b}\u0010zR0\u0010\u007f\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020~0x\u0018\u00010x8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u007f\u0010zR\"\u0010\u0080\u0001\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002050x8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0080\u0001\u0010zR\u001c\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0081\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0083\u0001R\u001c\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0084\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0085\u0001\u0010\u0086\u0001R/\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0087\u00012\t\u0010\u0015\u001a\u0005\u0018\u00010\u0087\u00018\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u0088\u0001\u0010\u0089\u0001\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001R+\u0010\u008d\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0015\u001a\u00030\u008c\u00018\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u008d\u0001\u0010\u008e\u0001\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001R\u0018\u0010\u0092\u0001\u001a\u00030\u0091\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0093\u0001R\u001c\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0094\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0095\u0001\u0010\u0096\u0001\u00a8\u0006\u0098\u0001"}, d2={"Lcom/github/p1k0chu/mcmod/bac_tracker/Main;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "T", "Ljava/util/concurrent/Callable;", "task", "Ljava/util/concurrent/Future;", "submitTask", "(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;", "", "onInitialize", "", "stat", "Lcom/github/p1k0chu/mcmod/bac_tracker/data/StatData;", "getStatFromPath", "(Ljava/lang/String;)Lcom/github/p1k0chu/mcmod/bac_tracker/data/StatData;", "Lnet/minecraft/class_8779;", "advancementEntry", "criteriaName", "", "value", "updateItem", "(Lnet/minecraft/class_8779;Ljava/lang/String;Z)V", "Lnet/minecraft/class_3222;", "player", "onAdvancementUpdate", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_8779;)V", "sheetName", "range", "", "index", "", "putUpdateInPool", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/Object;)V", "Lcom/github/p1k0chu/mcmod/bac_tracker/data/AdvancementData;", "oldAdvData", "Lnet/minecraft/class_167;", "newAdvProgress", "Lcom/github/p1k0chu/mcmod/bac_tracker/data/AdvancementData$Progress;", "newCriteriaProgress", "Ljava/time/Instant;", "newInstant", "applyAdvancementChangesInAPI", "(Lcom/github/p1k0chu/mcmod/bac_tracker/data/AdvancementData;Lnet/minecraft/class_167;Lcom/github/p1k0chu/mcmod/bac_tracker/data/AdvancementData$Progress;Lnet/minecraft/class_3222;Ljava/time/Instant;)V", "executePendingUpdates", "reloadConfigAndData", "()Z", "", "advIds", "statIds", "itemIds", "itemAdvIds", "Lcom/google/api/services/sheets/v4/model/ValueRange;", "kotlin.jvm.PlatformType", "getValueRangesToUpdateEverything", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "statTypes", "comps", "initializeStatsAndScoreboard", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "name", "comp", "initScoreboard", "(ILjava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/class_266;", "objective", "Lkotlin/Pair;", "maxScoreboardValue", "(Lnet/minecraft/class_266;Ljava/lang/String;)Lkotlin/Pair;", "initStat", "findMaxStatValueFromFiles", "(Ljava/lang/String;Ljava/lang/String;)Lkotlin/Pair;", "Ljava/nio/file/Path;", "advFile", "updateAdvancementsFromFile", "(Ljava/nio/file/Path;)V", "advId", "Lcom/google/gson/JsonObject;", "advJson", "playerUUID", "updateAdvancement", "(Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/String;)V", "updateItemsFromAdvancement", "(Ljava/lang/String;Lcom/google/gson/JsonObject;)V", "initializeAdv", "(Ljava/util/List;)V", "initializeItems", "(Ljava/util/List;Ljava/util/List;)V", "valueRanges", "Lcom/google/api/services/sheets/v4/model/BatchUpdateValuesResponse;", "batchUpdate", "(Ljava/util/List;)Lcom/google/api/services/sheets/v4/model/BatchUpdateValuesResponse;", "cellRanges", "batchGet", "(Ljava/util/List;)Ljava/util/List;", "cellRange", "getValueRange", "(Ljava/lang/String;)Lcom/google/api/services/sheets/v4/model/ValueRange;", "MOD_ID", "Ljava/lang/String;", "APP_NAME", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "Ljava/time/format/DateTimeFormatter;", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "getTimeFormatter", "()Ljava/time/format/DateTimeFormatter;", "Ljava/util/regex/Pattern;", "getStatRegex", "Ljava/util/regex/Pattern;", "", "advMap", "Ljava/util/Map;", "statMap", "Lcom/github/p1k0chu/mcmod/bac_tracker/data/ScoreboardData;", "scoreboardMap", "Lcom/github/p1k0chu/mcmod/bac_tracker/data/ItemData;", "itemMap", "updatePool", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/MinecraftServer;", "Lcom/google/api/services/sheets/v4/Sheets;", "sheetApi", "Lcom/google/api/services/sheets/v4/Sheets;", "Lcom/github/p1k0chu/mcmod/bac_tracker/settings/Settings;", "settings", "Lcom/github/p1k0chu/mcmod/bac_tracker/settings/Settings;", "getSettings", "()Lcom/github/p1k0chu/mcmod/bac_tracker/settings/Settings;", "Lcom/github/p1k0chu/mcmod/bac_tracker/Main$State;", "state", "Lcom/github/p1k0chu/mcmod/bac_tracker/Main$State;", "getState", "()Lcom/github/p1k0chu/mcmod/bac_tracker/Main$State;", "Ljava/util/concurrent/ExecutorService;", "executor", "Ljava/util/concurrent/ExecutorService;", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "State", "bac-tracker-mod"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ncom/github/p1k0chu/mcmod/bac_tracker/Main\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,778:1\n1863#2,2:779\n1557#2:781\n1628#2,3:782\n1557#2:785\n1628#2,3:786\n1557#2:789\n1628#2,2:790\n1630#2:793\n1557#2:794\n1628#2,3:795\n1557#2:798\n1628#2,3:799\n1557#2:802\n1628#2,3:803\n1567#2:806\n1598#2,4:807\n1863#2,2:811\n1557#2:813\n1628#2,3:814\n1#3:792\n*S KotlinDebug\n*F\n+ 1 Main.kt\ncom/github/p1k0chu/mcmod/bac_tracker/Main\n*L\n468#1:779,2\n514#1:781\n514#1:782,3\n517#1:785\n517#1:786,3\n520#1:789\n520#1:790,2\n520#1:793\n523#1:794\n523#1:795,3\n536#1:798\n536#1:799,3\n541#1:802\n541#1:803,3\n554#1:806\n554#1:807,4\n714#1:811,2\n764#1:813\n764#1:814,3\n*E\n"})
public final class Main
implements ModInitializer {
    @NotNull
    public static final Main INSTANCE = new Main();
    @NotNull
    public static final String MOD_ID = "bac-tracker-mod";
    @NotNull
    public static final String APP_NAME = "BACAP Tracker";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Gson GSON;
    @NotNull
    private static final DateTimeFormatter timeFormatter;
    @NotNull
    private static final Pattern getStatRegex;
    @Nullable
    private static Map<String, AdvancementData> advMap;
    @Nullable
    private static Map<String, StatData> statMap;
    @Nullable
    private static Map<String, ScoreboardData> scoreboardMap;
    @Nullable
    private static Map<String, Map<String, ItemData>> itemMap;
    @NotNull
    private static final Map<String, ValueRange> updatePool;
    @Nullable
    private static MinecraftServer server;
    @Nullable
    private static Sheets sheetApi;
    @Nullable
    private static Settings settings;
    @NotNull
    private static State state;
    @NotNull
    private static final ExecutorService executor;
    @Nullable
    private static ScheduledExecutorService scheduledExecutor;

    private Main() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final Gson getGSON() {
        return GSON;
    }

    @NotNull
    public final DateTimeFormatter getTimeFormatter() {
        return timeFormatter;
    }

    @Nullable
    public final Settings getSettings() {
        return settings;
    }

    @NotNull
    public final State getState() {
        return state;
    }

    @NotNull
    public final <T> Future<T> submitTask(@NotNull Callable<T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future<T> future = executor.submit(task);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(Main::onInitialize$lambda$0);
        ScoreboardUpdatedCallback.SCORE_UPDATED.register(Main::onInitialize$lambda$1);
        ServerLifecycleEvents.SERVER_STOPPING.register(Main::onInitialize$lambda$2);
        AdvancementUpdatedCallback.CRITERION_CHANGED.register(Main::onInitialize$lambda$3);
        StatUpdatedCallback.EVENT.register(Main::onInitialize$lambda$4);
        CommandRegistrationCallback.EVENT.register(TrackerCommand.INSTANCE::register);
    }

    private final StatData getStatFromPath(String stat) {
        Matcher m = getStatRegex.matcher(stat);
        if (!m.find()) {
            return null;
        }
        String type = m.group("type");
        String name = m.group("name");
        Map<String, StatData> map = statMap;
        return map != null ? map.get(type + "." + name) : null;
    }

    private final void updateItem(class_8779 advancementEntry, String criteriaName, boolean value) {
        block1: {
            String string = advancementEntry.comp_1919().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String advId = string;
            Map<String, Map<String, ItemData>> map = itemMap;
            if (map == null || (map = map.get(advId)) == null || (map = (ItemData)map.get(criteriaName)) == null) break block1;
            Map<String, Map<String, ItemData>> itemData = map;
            boolean bl = false;
            if (((ItemData)((Object)itemData)).getDone() != value) {
                ((ItemData)((Object)itemData)).setDone(value);
                Settings settings = Main.settings;
                Intrinsics.checkNotNull((Object)settings);
                String string2 = settings.getItemSheet().getName();
                Settings settings2 = Main.settings;
                Intrinsics.checkNotNull((Object)settings2);
                INSTANCE.putUpdateInPool(string2, settings2.getItemSheet().getStatusRange(), ((ItemData)((Object)itemData)).getIndex(), value);
            }
        }
    }

    private final void onAdvancementUpdate(class_3222 player, class_8779 advancementEntry) {
        block6: {
            Instant newInstant;
            AdvancementData.Progress newCriteriaProgress;
            class_167 advancementProgress;
            Map<String, AdvancementData> advancement;
            block5: {
                if (settings == null || sheetApi == null) {
                    return;
                }
                String string = advancementEntry.comp_1919().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String advId = string;
                Map<String, AdvancementData> map = advMap;
                if (map == null || (map = map.get(advId)) == null) {
                    return;
                }
                advancement = map;
                advancementProgress = player.method_14236().method_12882(advancementEntry);
                Intrinsics.checkNotNull((Object)advancementProgress, (String)"null cannot be cast to non-null type com.github.p1k0chu.mcmod.bac_tracker.utils.AdvancementProgressGetter");
                AdvancementProgressGetter progressGetter = (AdvancementProgressGetter)advancementProgress;
                AdvancementData.Progress progress = progressGetter.bac_tracker_mod$getProgress();
                Intrinsics.checkNotNullExpressionValue((Object)progress, (String)"bac_tracker_mod$getProgress(...)");
                newCriteriaProgress = progress;
                newInstant = progressGetter.bac_tracker_mod$getLatestProgressObtainDate();
                if (!((AdvancementData)((Object)advancement)).getDone() && advancementProgress.method_740()) break block5;
                AdvancementData.Progress progress2 = ((AdvancementData)((Object)advancement)).getProgress();
                if ((progress2 != null ? progress2.compareTo(newCriteriaProgress) : 0) >= 0) break block6;
            }
            this.applyAdvancementChangesInAPI((AdvancementData)((Object)advancement), advancementProgress, newCriteriaProgress, player, newInstant);
            ((AdvancementData)((Object)advancement)).setDone(advancementProgress.method_740());
            ((AdvancementData)((Object)advancement)).setProgress(newCriteriaProgress);
            ((AdvancementData)((Object)advancement)).setDoneTime(newInstant);
            ((AdvancementData)((Object)advancement)).setPlayer(player.method_5845());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putUpdateInPool(String sheetName, String range, int index, Object value) {
        String string = Utils.INSTANCE.moveRangeDownBy(range, index);
        if (string != null) {
            String cell = string;
            boolean bl = false;
            ValueRange valueRange = new ValueRange().setValues(CollectionsKt.listOf((Object)CollectionsKt.listOf((Object)value))).setRange(sheetName + "!" + cell);
            Map<String, ValueRange> map = updatePool;
            synchronized (map) {
                boolean bl2 = false;
                String string2 = sheetName + "!" + cell;
                Intrinsics.checkNotNull((Object)valueRange);
                ValueRange valueRange2 = updatePool.put(string2, valueRange);
            }
        }
    }

    private final void applyAdvancementChangesInAPI(AdvancementData oldAdvData, class_167 newAdvProgress, AdvancementData.Progress newCriteriaProgress, class_3222 player, Instant newInstant) {
        if (oldAdvData.getDone() != newAdvProgress.method_740()) {
            Settings settings = Main.settings;
            Intrinsics.checkNotNull((Object)settings);
            String string = settings.getAdvSheet().getName();
            Settings settings2 = Main.settings;
            Intrinsics.checkNotNull((Object)settings2);
            this.putUpdateInPool(string, settings2.getAdvSheet().getStatusRange(), oldAdvData.getIndex(), newAdvProgress.method_740());
        }
        if (!Intrinsics.areEqual((Object)oldAdvData.getProgress(), (Object)newCriteriaProgress)) {
            Settings settings = Main.settings;
            Intrinsics.checkNotNull((Object)settings);
            String string = settings.getAdvSheet().getName();
            Settings settings3 = Main.settings;
            Intrinsics.checkNotNull((Object)settings3);
            this.putUpdateInPool(string, settings3.getAdvSheet().getProgressRange(), oldAdvData.getIndex(), newCriteriaProgress.toString());
        }
        if (!Intrinsics.areEqual((Object)oldAdvData.getDoneTime(), (Object)newInstant)) {
            Settings settings = Main.settings;
            Intrinsics.checkNotNull((Object)settings);
            String string = settings.getAdvSheet().getName();
            Settings settings4 = Main.settings;
            Intrinsics.checkNotNull((Object)settings4);
            this.putUpdateInPool(string, settings4.getAdvSheet().getWhenRange(), oldAdvData.getIndex(), timeFormatter.format(newInstant));
        }
        if (!Intrinsics.areEqual((Object)oldAdvData.getPlayer(), (Object)player.method_5845())) {
            Settings settings = Main.settings;
            Intrinsics.checkNotNull((Object)settings);
            String string = settings.getAdvSheet().getName();
            Settings settings5 = Main.settings;
            Intrinsics.checkNotNull((Object)settings5);
            this.putUpdateInPool(string, settings5.getAdvSheet().getWhoRange(), oldAdvData.getIndex(), Utils.INSTANCE.getProfilePictureByUuid(player.method_5845()));
        }
        Settings settings = Main.settings;
        Intrinsics.checkNotNull((Object)settings);
        String string = settings.getAdvSheet().getName();
        Settings settings6 = Main.settings;
        Intrinsics.checkNotNull((Object)settings6);
        String string2 = settings6.getAdvSheet().getIncompleteCriteriaRange();
        int n = oldAdvData.getIndex();
        Iterable iterable = newAdvProgress.method_731();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getUnobtainedCriteria(...)");
        this.putUpdateInPool(string, string2, n, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executePendingUpdates() {
        if (state != State.INITIALIZED) {
            return;
        }
        List updates = new ArrayList();
        Map<String, ValueRange> map = updatePool;
        synchronized (map) {
            boolean bl = false;
            Iterator<ValueRange> it = updatePool.values().iterator();
            while (it.hasNext()) {
                updates.add(it.next());
                it.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (updates.isEmpty()) {
            return;
        }
        this.submitTask(() -> Main.executePendingUpdates$lambda$9(updates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reloadConfigAndData() {
        try {
            Path path = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path settingsGlobalFolder = path;
            Object object = server;
            if (object == null || (object = object.method_27050(class_5218.field_24188)) == null || (object = object.resolve("tracker")) == null) {
                return false;
            }
            Object settingsPerWorldFolder = object;
            Object object2 = server;
            if (object2 == null || (object2 = object2.method_27050(class_5218.field_24180)) == null) {
                return false;
            }
            Object advancementFolder = object2;
            Path credPath = settingsGlobalFolder.resolve("credentials.json");
            Path settingsFile = settingsPerWorldFolder.resolve("settings.json");
            Utils.INSTANCE.makeSureDirectoryExists(settingsGlobalFolder);
            Utils.INSTANCE.makeSureDirectoryExists((Path)settingsPerWorldFolder);
            if (!settingsFile.toFile().exists()) {
                File file = settingsFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                Object object3 = file;
                Object object4 = Charsets.UTF_8;
                object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object4);
                object4 = null;
                try {
                    OutputStreamWriter w = (OutputStreamWriter)object3;
                    boolean bl = false;
                    GSON.toJson((Object)new Settings(null, 0L, false, false, null, null, null, 127, null), (Appendable)w);
                    w = Unit.INSTANCE;
                }
                catch (Throwable w) {
                    object4 = w;
                    throw w;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                }
                throw new FileNotFoundException("settings file is missing. created new file for you, edit at: " + settingsFile.toAbsolutePath().normalize());
            }
            Intrinsics.checkNotNull((Object)credPath);
            sheetApi = Utils.INSTANCE.buildSheet(credPath);
            File file = settingsFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            List<List<String>> list = file;
            Object[] objectArray = Charsets.UTF_8;
            list = new InputStreamReader((InputStream)new FileInputStream((File)((Object)list)), (Charset)objectArray);
            objectArray = null;
            try {
                Object r = (InputStreamReader)((Object)list);
                boolean bl = false;
                r = (Settings)GSON.fromJson((Reader)r, Settings.class);
            }
            catch (Throwable r) {
                objectArray = r;
                throw r;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list), (Throwable)objectArray);
            }
            settings = r;
            Settings settings = Main.settings;
            Intrinsics.checkNotNull((Object)settings);
            Settings settings2 = Main.settings;
            Intrinsics.checkNotNull((Object)settings2);
            settings.setSheetId(Utils.INSTANCE.getIdOrUrl(settings2.getSheetId()));
            objectArray = new String[2];
            Settings settings3 = Main.settings;
            Intrinsics.checkNotNull((Object)settings3);
            String string = settings3.getItemSheet().getName();
            Settings settings4 = Main.settings;
            Intrinsics.checkNotNull((Object)settings4);
            objectArray[0] = string + "!" + settings4.getItemSheet().getIdRange();
            Settings settings5 = Main.settings;
            Intrinsics.checkNotNull((Object)settings5);
            String string2 = settings5.getItemSheet().getName();
            Settings settings6 = Main.settings;
            Intrinsics.checkNotNull((Object)settings6);
            objectArray[1] = string2 + "!" + settings6.getItemSheet().getAdvRange();
            List<List<String>> list2 = this.batchGet(CollectionsKt.listOf((Object[])objectArray));
            Intrinsics.checkNotNull(list2);
            list = list2;
            List<String> itemIds = list.get(0);
            List<String> itemAdvIds = list.get(1);
            this.initializeItems(itemIds, itemAdvIds);
            Settings settings7 = Main.settings;
            Intrinsics.checkNotNull((Object)settings7);
            String string3 = settings7.getAdvSheet().getName();
            Settings settings8 = Main.settings;
            Intrinsics.checkNotNull((Object)settings8);
            ValueRange valueRange = this.getValueRange(string3 + "!" + settings8.getAdvSheet().getIdRange());
            Intrinsics.checkNotNull((Object)valueRange);
            List<String> advIds = Utils.INSTANCE.singleColumnValueRange(valueRange);
            this.initializeAdv(advIds);
            Iterable $this$forEach$iv = PathsKt.listDirectoryEntries((Path)advancementFolder, (String)"*.json");
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Path p0 = (Path)element$iv;
                boolean $i$f$reloadConfigAndData$stub_for_inlining = false;
                boolean bl = false;
                this.updateAdvancementsFromFile(p0);
            }
            Object[] $i$f$forEach22 = new String[3];
            Settings settings9 = Main.settings;
            Intrinsics.checkNotNull((Object)settings9);
            String string4 = settings9.getStatSheet().getName();
            Settings settings10 = Main.settings;
            Intrinsics.checkNotNull((Object)settings10);
            $i$f$forEach22[0] = string4 + "!" + settings10.getStatSheet().getIdRange();
            Settings settings11 = Main.settings;
            Intrinsics.checkNotNull((Object)settings11);
            String string5 = settings11.getStatSheet().getName();
            Settings settings12 = Main.settings;
            Intrinsics.checkNotNull((Object)settings12);
            $i$f$forEach22[1] = string5 + "!" + settings12.getStatSheet().getTypeRange();
            Settings settings13 = Main.settings;
            Intrinsics.checkNotNull((Object)settings13);
            String string6 = settings13.getStatSheet().getName();
            Settings settings14 = Main.settings;
            Intrinsics.checkNotNull((Object)settings14);
            $i$f$forEach22[2] = string6 + "!" + settings14.getStatSheet().getComparingTypeRange();
            List<List<String>> list3 = this.batchGet(CollectionsKt.listOf((Object[])$i$f$forEach22));
            Intrinsics.checkNotNull(list3);
            List<List<String>> list4 = list3;
            List<String> statIds = list4.get(0);
            List<String> statTypes = list4.get(1);
            List<String> comps = list4.get(2);
            this.initializeStatsAndScoreboard(statIds, statTypes, comps);
            this.batchUpdate(this.getValueRangesToUpdateEverything(advIds, statIds, itemIds, itemAdvIds));
            state = State.INITIALIZED;
            ScheduledExecutorService scheduledExecutorService = scheduledExecutor;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdown();
            }
            ScheduledExecutorService scheduledExecutorService2 = scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNull((Object)scheduledExecutorService2);
            Runnable runnable = this::executePendingUpdates;
            Settings settings15 = Main.settings;
            Intrinsics.checkNotNull((Object)settings15);
            long l = settings15.getUpdateDelaySeconds();
            Settings settings16 = Main.settings;
            Intrinsics.checkNotNull((Object)settings16);
            scheduledExecutorService2.scheduleWithFixedDelay(runnable, l, settings16.getUpdateDelaySeconds(), TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            state = State.NOT_INITIALIZED;
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<ValueRange> getValueRangesToUpdateEverything(List<String> advIds, List<String> statIds, List<String> itemIds, List<String> itemAdvIds) {
        var5_5 = new ValueRange[7];
        v0 = new ValueRange();
        v1 = Main.settings;
        Intrinsics.checkNotNull((Object)v1);
        v2 = v1.getAdvSheet().getName();
        v3 = Main.settings;
        Intrinsics.checkNotNull((Object)v3);
        var6_6 = advIds;
        var23_7 = v0.setRange(v2 + "!" + v3.getAdvSheet().getStatusRange());
        var22_8 = 0;
        var21_9 = var5_5;
        $i$f$map = false;
        var8_11 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_17 = (String)item$iv$iv;
            var24_19 = destination$iv$iv;
            $i$a$-map-Main$getValueRangesToUpdateEverything$1 = false;
            v4 = Main.advMap;
            var24_19.add(CollectionsKt.listOf(v4 != null && (v4 = v4.get(i)) != null ? Boolean.valueOf(v4.getDone()) : null));
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues((List)var24_19);
        v5 = new ValueRange();
        v6 = Main.settings;
        Intrinsics.checkNotNull((Object)v6);
        v7 = v6.getAdvSheet().getName();
        v8 = Main.settings;
        Intrinsics.checkNotNull((Object)v8);
        $this$map$iv = advIds;
        var23_7 = v5.setRange(v7 + "!" + v8.getAdvSheet().getProgressRange());
        var22_8 = 1;
        var21_9 = var5_5;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            i = (String)item$iv$iv;
            var24_19 = destination$iv$iv;
            $i$a$-map-Main$getValueRangesToUpdateEverything$2 = false;
            v9 = Main.advMap;
            var24_19.add(CollectionsKt.listOf(v9 != null && (v9 = v9.get(i)) != null && (v9 = v9.getProgress()) != null ? v9.toString() : null));
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues(var24_19);
        v10 = new ValueRange();
        v11 = Main.settings;
        Intrinsics.checkNotNull((Object)v11);
        v12 = v11.getAdvSheet().getName();
        v13 = Main.settings;
        Intrinsics.checkNotNull((Object)v13);
        $this$map$iv = advIds;
        var23_7 = v10.setRange(v12 + "!" + v13.getAdvSheet().getWhenRange());
        var22_8 = 2;
        var21_9 = var5_5;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            i = (String)item$iv$iv;
            var24_19 = destination$iv$iv;
            $i$a$-map-Main$getValueRangesToUpdateEverything$3 = false;
            v14 = Main.advMap;
            if (v14 != null && (v14 = v14.get(i)) != null && (v14 = v14.getDoneTime()) != null) {
                var15_20 /* !! */  = v14;
                var16_21 = Main.timeFormatter;
                p0 = (TemporalAccessor)var15_20 /* !! */ ;
                $i$a$-let-Main$getValueRangesToUpdateEverything$3$1 = false;
                $i$f$getValueRangesToUpdateEverything$lambda$15$stub_for_inlining$14 = false;
                v15 = var16_21.format((TemporalAccessor)p0);
            } else {
                v15 = null;
            }
            var24_19.add(CollectionsKt.listOf(v15));
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues(var24_19);
        v16 = new ValueRange();
        v17 = Main.settings;
        Intrinsics.checkNotNull((Object)v17);
        v18 = v17.getAdvSheet().getName();
        v19 = Main.settings;
        Intrinsics.checkNotNull((Object)v19);
        $this$map$iv = advIds;
        var23_7 = v16.setRange(v18 + "!" + v19.getAdvSheet().getWhoRange());
        var22_8 = 3;
        var21_9 = var5_5;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            i = (String)item$iv$iv;
            var24_19 = destination$iv$iv;
            $i$a$-map-Main$getValueRangesToUpdateEverything$4 = false;
            var15_20 /* !! */  = Main.advMap;
            var24_19.add(CollectionsKt.listOf((Object)Utils.INSTANCE.getProfilePictureByUuid(var15_20 /* !! */  != null && (var16_21 = var15_20 /* !! */ .get(i)) != null ? var16_21.getPlayer() : null)));
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues(var24_19);
        v20 = new ValueRange();
        v21 = Main.settings;
        Intrinsics.checkNotNull((Object)v21);
        v22 = v21.getStatSheet().getName();
        v23 = Main.settings;
        Intrinsics.checkNotNull((Object)v23);
        $this$map$iv = statIds;
        var23_7 = v20.setRange(v22 + "!" + v23.getStatSheet().getValueRange());
        var22_8 = 4;
        var21_9 = var5_5;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            i = (String)item$iv$iv;
            var24_19 = destination$iv$iv;
            $i$a$-map-Main$getValueRangesToUpdateEverything$5 = false;
            v24 = Main.statMap;
            var24_19.add(CollectionsKt.listOf((Object)(v24 != null && (v24 = v24.get(i)) != null ? Integer.valueOf(v24.getValue()) : ((v25 = Main.scoreboardMap) != null && (v25 = v25.get(i)) != null ? Integer.valueOf(v25.getValue()) : null))));
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues(var24_19);
        v26 = new ValueRange();
        v27 = Main.settings;
        Intrinsics.checkNotNull((Object)v27);
        v28 = v27.getStatSheet().getName();
        v29 = Main.settings;
        Intrinsics.checkNotNull((Object)v29);
        $this$map$iv = statIds;
        var23_7 = v26.setRange(v28 + "!" + v29.getStatSheet().getWhoRange());
        var22_8 = 5;
        var21_9 = var5_5;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            i = (String)item$iv$iv;
            var24_19 = destination$iv$iv;
            $i$a$-map-Main$getValueRangesToUpdateEverything$6 = false;
            v30 = Main.statMap;
            if (v30 != null && (v30 = v30.get(i)) != null && (v30 = v30.getPlayer()) != null) ** GOTO lbl163
            var15_20 /* !! */  = Main.server;
            if (var15_20 /* !! */  == null || (var16_21 = var15_20 /* !! */ .method_3793()) == null) ** GOTO lbl-1000
            v31 = Main.scoreboardMap;
            if (v31 == null || (v31 = v31.get(i)) == null || (v31 = v31.getPlayer()) == null) {
                v32 = p0 = CollectionsKt.emptyList();
            } else {
                var18_26 = var16_21.method_14515((String)v31);
                if (var18_26 != null && (var19_28 = (GameProfile)OptionalsKt.getOrNull((Optional)var18_26)) != null && (var20_29 = var19_28.getId()) != null) {
                    v30 = var20_29.toString();
                } else lbl-1000:
                // 2 sources

                {
                    v30 = null;
                }
lbl163:
                // 3 sources

                v32 = CollectionsKt.listOf((Object)Utils.INSTANCE.getProfilePictureByUuid((String)v30));
            }
            var24_19.add((List)v32);
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues(var24_19);
        v33 = new ValueRange();
        v34 = Main.settings;
        Intrinsics.checkNotNull((Object)v34);
        v35 = v34.getItemSheet().getName();
        v36 = Main.settings;
        Intrinsics.checkNotNull((Object)v36);
        $this$map$iv = itemIds;
        var23_7 = v33.setRange(v35 + "!" + v36.getItemSheet().getStatusRange());
        var22_8 = 6;
        var21_9 = var5_5;
        $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        $i$f$mapIndexedTo = false;
        index$iv$iv = 0;
        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
            if ((var14_18 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            var15_20 /* !! */  = (String)item$iv$iv;
            var16_22 = var14_18;
            var24_19 = destination$iv$iv;
            $i$a$-mapIndexed-Main$getValueRangesToUpdateEverything$7 = false;
            v37 = Main.itemMap;
            var24_19.add(CollectionsKt.listOf(v37 != null && (v37 = v37.get(itemAdvIds.get((int)i))) != null && (v37 = (ItemData)v37.get(itemId)) != null ? Boolean.valueOf(v37.getDone()) : null));
        }
        var24_19 = (List)destination$iv$iv;
        var21_9[var22_8] = var23_7.setValues(var24_19);
        return CollectionsKt.listOf((Object[])var5_5);
    }

    private final void initializeStatsAndScoreboard(List<String> statIds, List<String> statTypes, List<String> comps) {
        scoreboardMap = new LinkedHashMap();
        statMap = new LinkedHashMap();
        int n = ((Collection)statIds).size();
        for (int i = 0; i < n; ++i) {
            String comp;
            String name;
            String type;
            if (statIds.get(i) == null || statTypes.get(i) == null || comps.get(i) == null) continue;
            String string = type;
            if (Intrinsics.areEqual((Object)string, (Object)"stat")) {
                this.initStat(i, name, comp);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"scoreboard")) {
                this.initScoreboard(i, name, comp);
                continue;
            }
            Object[] objectArray = new Object[]{type, name, i + 1};
            logger.warn("Incorrect type \"{}\" for stat \"{}\" at row {}", objectArray);
        }
    }

    private final void initScoreboard(int index, String name, String comp) {
        MinecraftServer minecraftServer = server;
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_266 objective = minecraftServer.method_3845().method_1170(name);
        if (objective == null) {
            logger.warn("non-existent scoreboard objective: {}", (Object)name);
            return;
        }
        Pair<Integer, String> pair = this.maxScoreboardValue(objective, comp);
        int maxValue = ((Number)pair.component1()).intValue();
        String maxValuePlayer = (String)pair.component2();
        if (maxValuePlayer != null) {
            MinecraftServer minecraftServer2 = server;
            Intrinsics.checkNotNull((Object)minecraftServer2);
            Object object = minecraftServer2.method_3793();
            maxValuePlayer = object != null && (object = object.method_14515(maxValuePlayer)) != null && (object = (GameProfile)OptionalsKt.getOrNull((Optional)object)) != null && (object = object.getId()) != null ? ((UUID)object).toString() : null;
        }
        Map<String, ScoreboardData> map = scoreboardMap;
        Intrinsics.checkNotNull(map);
        map.put(name, new ScoreboardData(comp, maxValue, maxValuePlayer, index));
    }

    private final Pair<Integer, String> maxScoreboardValue(class_266 objective, String comp) {
        int maxValue = 0;
        String maxValuePlayer = null;
        MinecraftServer minecraftServer = server;
        Intrinsics.checkNotNull((Object)minecraftServer);
        for (class_9011 entry : minecraftServer.method_3845().method_1184(objective)) {
            int value = entry.comp_2128();
            if (Intrinsics.areEqual((Object)comp, (Object)"max")) {
                if (value <= maxValue) continue;
                maxValue = value;
                maxValuePlayer = entry.comp_2127();
                continue;
            }
            if (Intrinsics.areEqual((Object)comp, (Object)"sum")) {
                maxValue += value;
                continue;
            }
            logger.warn("Incorrect comparison type for scoreboard \"{}\": \"{}\"", (Object)objective.method_1113(), (Object)comp);
        }
        return TuplesKt.to((Object)maxValue, maxValuePlayer);
    }

    private final void initStat(int index, String name, String comp) {
        Pair<Integer, String> pair = this.findMaxStatValueFromFiles(name, comp);
        if (pair == null) {
            return;
        }
        Pair<Integer, String> pair2 = pair;
        int bestValue = ((Number)pair2.component1()).intValue();
        String bestPlayer = (String)pair2.component2();
        Map<String, StatData> map = statMap;
        Intrinsics.checkNotNull(map);
        map.put(name, new StatData(bestPlayer, comp, bestValue, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Integer, String> findMaxStatValueFromFiles(String name, String comp) {
        String[] stringArray = new String[]{"."};
        List x = StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        if (x.size() < 2) {
            logger.error("wrong format for stat ({}) in the sheet: must be category.name; e.g. \"custom.deaths\"; skipping", (Object)name);
            return null;
        }
        String statType = (String)x.get(0);
        String statObj = (String)x.get(1);
        int bestValue = 0;
        String bestPlayer = null;
        MinecraftServer minecraftServer = server;
        Intrinsics.checkNotNull((Object)minecraftServer);
        File[] fileArray = minecraftServer.method_27050(class_5218.field_24181).toFile().listFiles(Main::findMaxStatValueFromFiles$lambda$20);
        Intrinsics.checkNotNull((Object)fileArray);
        for (File f : fileArray) {
            JsonObject j;
            JsonObject jsonObject;
            Object object = f;
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader r = (InputStreamReader)object;
                boolean bl = false;
                jsonObject = ((JsonObject)GSON.fromJson((Reader)r, JsonObject.class)).get("stats").getAsJsonObject();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"use(...)");
            JsonElement jsonElement = j.get("minecraft:" + statType);
            if (jsonElement == null || (jsonElement = jsonElement.getAsJsonObject()) == null || (jsonElement = jsonElement.get("minecraft:" + statObj)) == null) {
                continue;
            }
            int value = jsonElement.getAsInt();
            if (Intrinsics.areEqual((Object)comp, (Object)"max")) {
                if (value <= bestValue) continue;
                bestValue = value;
                bestPlayer = FilesKt.getNameWithoutExtension((File)f);
                continue;
            }
            if (Intrinsics.areEqual((Object)comp, (Object)"sum")) {
                bestValue += value;
                continue;
            }
            logger.warn("Incorrect comparison type for stat \"{}\": \"{}\"", (Object)name, (Object)comp);
        }
        return TuplesKt.to((Object)bestValue, bestPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateAdvancementsFromFile(Path advFile) {
        JsonObject jsonObject;
        Object object = advFile;
        JsonObject jsonObject2 = new JsonObject[]{};
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(jsonObject2, ((OpenOption[])jsonObject2).length)), (Charset)object2);
        object2 = null;
        try {
            InputStreamReader r = (InputStreamReader)object;
            boolean bl = false;
            jsonObject2 = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            jsonObject = jsonObject2;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"use(...)");
        JsonObject advFileJson = jsonObject;
        for (String advId : advFileJson.keySet()) {
            JsonObject advJson;
            JsonElement jsonElement = advFileJson.get(advId);
            Intrinsics.checkNotNull((Object)jsonElement);
            if (!jsonElement.isJsonObject()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)advFileJson.get(advId).getAsJsonObject(), (String)"getAsJsonObject(...)");
            Intrinsics.checkNotNull((Object)advId);
            this.updateAdvancement(advId, advJson, PathsKt.getNameWithoutExtension((Path)advFile));
            this.updateItemsFromAdvancement(advId, advJson);
        }
    }

    private final void updateAdvancement(String advId, JsonObject advJson, String playerUUID) {
        block1: {
            Map<String, AdvancementData> adv;
            block2: {
                Map<String, AdvancementData> map = advMap;
                if (map == null || (map = map.get(advId)) == null) {
                    return;
                }
                adv = map;
                if (((AdvancementData)((Object)adv)).getDone()) break block1;
                JsonElement jsonElement = advJson.get("done");
                boolean bl = jsonElement != null ? jsonElement.getAsBoolean() : false;
                if (!bl) break block2;
                ((AdvancementData)((Object)adv)).setDone(true);
                ((AdvancementData)((Object)adv)).setPlayer(playerUUID);
                ((AdvancementData)((Object)adv)).setDoneTime(Utils.INSTANCE.findLatestCriteriaObtainedDate(advJson));
                AdvancementData.Progress progress = ((AdvancementData)((Object)adv)).getProgress();
                if (progress == null) break block1;
                AdvancementData.Progress progress2 = ((AdvancementData)((Object)adv)).getProgress();
                Intrinsics.checkNotNull((Object)progress2);
                progress.setNom(progress2.getDen());
                break block1;
            }
            AdvancementData.Progress progress = ((AdvancementData)((Object)adv)).getProgress();
            if (progress == null) break block1;
            progress.setNom(advJson.get("criteria").getAsJsonObject().size());
        }
    }

    private final void updateItemsFromAdvancement(String advId, JsonObject advJson) {
        block1: {
            Map<String, Object> map = itemMap;
            if (map == null || (map = map.get(advId)) == null) break block1;
            Map<String, Object> itemAdvancement = map;
            boolean bl = false;
            Set set = advJson.get("criteria").getAsJsonObject().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String criteria = (String)element$iv;
                boolean bl2 = false;
                ItemData itemData = (ItemData)itemAdvancement.get(criteria);
                if (itemData == null) continue;
                itemData.setDone(true);
            }
        }
    }

    private final void initializeAdv(List<String> advIds) {
        advMap = new LinkedHashMap();
        int n = ((Collection)advIds).size();
        for (int i = 0; i < n; ++i) {
            MinecraftServer minecraftServer = server;
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_8779 advancementEntry = minecraftServer.method_3851().method_12896(class_2960.method_60654((String)advIds.get(i)));
            if (advancementEntry == null) {
                logger.warn("Couldn't find loaded advancement with name {}", (Object)advIds.get(i));
                continue;
            }
            Map<String, AdvancementData> map = advMap;
            Intrinsics.checkNotNull(map);
            map.put(advIds.get(i), new AdvancementData(false, null, null, i, new AdvancementData.Progress(0, advancementEntry.comp_1920().comp_1915().size())));
        }
    }

    private final void initializeItems(List<String> itemIds, List<String> itemAdvIds) {
        itemMap = new LinkedHashMap();
        int n = ((Collection)itemIds).size();
        for (int i = 0; i < n; ++i) {
            Map<String, Map<String, ItemData>> map = itemMap;
            Intrinsics.checkNotNull(map);
            if (!map.containsKey(itemAdvIds.get(i))) {
                Map<String, Map<String, ItemData>> map2 = itemMap;
                Intrinsics.checkNotNull(map2);
                map2.put(itemAdvIds.get(i), new LinkedHashMap());
            }
            Map<String, Map<String, ItemData>> map3 = itemMap;
            Intrinsics.checkNotNull(map3);
            Map<String, ItemData> map4 = map3.get(itemAdvIds.get(i));
            Intrinsics.checkNotNull(map4);
            map4.put(itemIds.get(i), new ItemData(false, i, 1, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BatchUpdateValuesResponse batchUpdate(List<ValueRange> valueRanges) {
        BatchUpdateValuesRequest body = new BatchUpdateValuesRequest().setValueInputOption("USER_ENTERED").setIncludeValuesInResponse(Boolean.valueOf(false)).setData(valueRanges);
        Sheets sheets = sheetApi;
        Sheets sheets2 = sheets;
        if (sheets == null) return null;
        Sheets.Spreadsheets spreadsheets = sheets2.spreadsheets();
        sheets2 = spreadsheets;
        if (spreadsheets == null) return null;
        Sheets.Spreadsheets.Values values = sheets2.values();
        sheets2 = values;
        if (values == null) return null;
        Settings settings = Main.settings;
        Object object = settings;
        if (settings == null) return null;
        if ((object = ((Settings)object).getSheetId()) == null) {
            return null;
        }
        Sheets.Spreadsheets.Values.BatchUpdate batchUpdate = sheets2.batchUpdate((String)object, body);
        sheets2 = batchUpdate;
        if (batchUpdate == null) return null;
        BatchUpdateValuesResponse batchUpdateValuesResponse = (BatchUpdateValuesResponse)sheets2.execute();
        return batchUpdateValuesResponse;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<List<String>> batchGet(List<String> cellRanges) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Sheets sheets = sheetApi;
        if (sheets == null) return null;
        Sheets.Spreadsheets spreadsheets = sheets.spreadsheets();
        if (spreadsheets == null) return null;
        Sheets.Spreadsheets.Values values = spreadsheets.values();
        if (values == null) return null;
        Settings settings = Main.settings;
        Object object = settings;
        if (settings == null) return null;
        if ((object = ((Settings)object).getSheetId()) == null) {
            return null;
        }
        Sheets.Spreadsheets.Values.BatchGet batchGet = values.batchGet((String)object);
        if (batchGet == null) return null;
        Sheets.Spreadsheets.Values.BatchGet batchGet2 = batchGet.setRanges(cellRanges);
        if (batchGet2 == null) return null;
        BatchGetValuesResponse batchGetValuesResponse = (BatchGetValuesResponse)batchGet2.execute();
        if (batchGetValuesResponse == null) return null;
        List list = batchGetValuesResponse.getValueRanges();
        if (list == null) return null;
        Iterable iterable = list;
        Utils utils = Utils.INSTANCE;
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ValueRange valueRange = (ValueRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$batchGet$stub_for_inlining$25 = false;
            boolean bl = false;
            collection.add(utils.singleColumnValueRange((ValueRange)p0));
        }
        List list2 = (List)destination$iv$iv;
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ValueRange getValueRange(String cellRange) {
        Sheets sheets = sheetApi;
        if (sheets == null) return null;
        Sheets.Spreadsheets spreadsheets = sheets.spreadsheets();
        if (spreadsheets == null) return null;
        Sheets.Spreadsheets.Values values = spreadsheets.values();
        if (values == null) return null;
        Settings settings = Main.settings;
        Object object = settings;
        if (settings == null) return null;
        if ((object = ((Settings)object).getSheetId()) == null) {
            return null;
        }
        Sheets.Spreadsheets.Values.Get get = values.get((String)object, cellRange);
        if (get == null) return null;
        ValueRange valueRange = (ValueRange)get.execute();
        return valueRange;
    }

    private static final void onInitialize$lambda$0(MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Main.server = server;
        INSTANCE.submitTask(INSTANCE::reloadConfigAndData);
    }

    private static final void onInitialize$lambda$1(String ownerUUID, class_266 objective, int oldScore, int newScore) {
        Intrinsics.checkNotNullParameter((Object)ownerUUID, (String)"ownerUUID");
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        Settings settings = Main.settings;
        if (!(settings != null ? settings.getScoreboardEnabled() : false)) {
            return;
        }
        Map<String, ScoreboardData> map = scoreboardMap;
        if (map == null || (map = map.get(objective.method_1113())) == null) {
            return;
        }
        Map<String, ScoreboardData> scoreboardData = map;
        switch (WhenMappings.$EnumSwitchMapping$0[((ScoreboardData)((Object)scoreboardData)).getType().ordinal()]) {
            case 1: {
                int change = newScore - oldScore;
                int i = (int)Math.min(Integer.MAX_VALUE, (long)((ScoreboardData)((Object)scoreboardData)).getValue() + (long)change);
                ((ScoreboardData)((Object)scoreboardData)).setValue(i);
                break;
            }
            case 2: {
                if (((ScoreboardData)((Object)scoreboardData)).getValue() > newScore) {
                    return;
                }
                ((ScoreboardData)((Object)scoreboardData)).setValue(newScore);
                if (Intrinsics.areEqual((Object)ownerUUID, (Object)((ScoreboardData)((Object)scoreboardData)).getPlayer())) break;
                ((ScoreboardData)((Object)scoreboardData)).setPlayer(ownerUUID);
                Settings settings2 = Main.settings;
                Intrinsics.checkNotNull((Object)settings2);
                String string = settings2.getStatSheet().getName();
                Settings settings3 = Main.settings;
                Intrinsics.checkNotNull((Object)settings3);
                INSTANCE.putUpdateInPool(string, settings3.getStatSheet().getWhoRange(), ((ScoreboardData)((Object)scoreboardData)).getIndex(), Utils.INSTANCE.getProfilePictureByUuid(((ScoreboardData)((Object)scoreboardData)).getPlayer()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Settings settings4 = Main.settings;
        Intrinsics.checkNotNull((Object)settings4);
        String string = settings4.getStatSheet().getName();
        Settings settings5 = Main.settings;
        Intrinsics.checkNotNull((Object)settings5);
        INSTANCE.putUpdateInPool(string, settings5.getStatSheet().getValueRange(), ((ScoreboardData)((Object)scoreboardData)).getIndex(), ((ScoreboardData)((Object)scoreboardData)).getValue());
    }

    private static final void onInitialize$lambda$2(MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        advMap = null;
        statMap = null;
        scoreboardMap = null;
        itemMap = null;
        Main.server = null;
        ScheduledExecutorService scheduledExecutorService = scheduledExecutor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdown();
        }
        scheduledExecutor = null;
        if (server.method_3816()) {
            executor.shutdown();
        }
        state = State.NOT_INITIALIZED;
    }

    private static final void onInitialize$lambda$3(class_3222 player, class_8779 advancementEntry, String criteriaName, boolean value) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)advancementEntry, (String)"advancementEntry");
                Intrinsics.checkNotNullParameter((Object)criteriaName, (String)"criteriaName");
                if (state != State.INITIALIZED) break block2;
                if (settings != null) break block3;
            }
            return;
        }
        INSTANCE.onAdvancementUpdate(player, advancementEntry);
        INSTANCE.updateItem(advancementEntry, criteriaName, value);
    }

    private static final void onInitialize$lambda$4(class_1657 player, class_3445 stat, int oldValue, int newValue) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        if (state != State.INITIALIZED) {
            return;
        }
        Settings settings = Main.settings;
        if (!(settings != null ? settings.getStatEnabled() : false)) {
            return;
        }
        String string = stat.method_1225();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        StatData statData = INSTANCE.getStatFromPath(string);
        if (statData == null) {
            return;
        }
        StatData statData2 = statData;
        switch (WhenMappings.$EnumSwitchMapping$0[statData2.getType().ordinal()]) {
            case 1: {
                int change = newValue - oldValue;
                int i = (int)Math.min((long)statData2.getValue() + (long)change, Integer.MAX_VALUE);
                statData2.setValue(i);
                break;
            }
            case 2: {
                if (newValue > statData2.getValue()) {
                    statData2.setValue(newValue);
                    if (Intrinsics.areEqual((Object)statData2.getPlayer(), (Object)player.method_5845())) break;
                    statData2.setPlayer(player.method_5845());
                    Settings settings2 = Main.settings;
                    Intrinsics.checkNotNull((Object)settings2);
                    String string2 = settings2.getStatSheet().getName();
                    Settings settings3 = Main.settings;
                    Intrinsics.checkNotNull((Object)settings3);
                    INSTANCE.putUpdateInPool(string2, settings3.getStatSheet().getWhoRange(), statData2.getIndex(), Utils.INSTANCE.getProfilePictureByUuid(player.method_5845()));
                    break;
                }
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Settings settings4 = Main.settings;
        Intrinsics.checkNotNull((Object)settings4);
        String string3 = settings4.getStatSheet().getName();
        Settings settings5 = Main.settings;
        Intrinsics.checkNotNull((Object)settings5);
        INSTANCE.putUpdateInPool(string3, settings5.getStatSheet().getValueRange(), statData2.getIndex(), newValue);
    }

    private static final Object executePendingUpdates$lambda$9(List $updates) {
        BatchUpdateValuesResponse batchUpdateValuesResponse;
        try {
            batchUpdateValuesResponse = INSTANCE.batchUpdate($updates);
        }
        catch (Exception e) {
            logger.error("Caught exception while making api request", (Throwable)e);
            MinecraftServer minecraftServer = server;
            if (minecraftServer != null) {
                minecraftServer.method_43496(class_2561.method_30163((String)"Caught exception while making api request, mod automatically shuts down... run `/tracker reload` when you think you fixed your stuff"));
            }
            state = State.NOT_INITIALIZED;
            batchUpdateValuesResponse = Unit.INSTANCE;
        }
        return batchUpdateValuesResponse;
    }

    private static final boolean findMaxStatValueFromFiles$lambda$20(File f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        String string = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Main.logger = logger;
        Gson gson = new Gson().newBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("h:mm:ss a dd-MM-yyyy z Z").withLocale(Locale.of("en-US")).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        timeFormatter = dateTimeFormatter;
        Pattern pattern = Pattern.compile("minecraft\\.(?<type>.+):minecraft\\.(?<name>.+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        getStatRegex = pattern;
        updatePool = new LinkedHashMap();
        state = State.NOT_INITIALIZED;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        executor = executorService;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/p1k0chu/mcmod/bac_tracker/Main$State;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_INITIALIZED", "INITIALIZED", "bac-tracker-mod"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_INITIALIZED = new State();
        public static final /* enum */ State INITIALIZED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_INITIALIZED, State.INITIALIZED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComparingType.values().length];
            try {
                nArray[ComparingType.SUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparingType.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

