/*
 * Decompiled with CFR 0.152.
 */
package com.github.p1k0chu.mcmod.bac_tracker.utils;

import com.github.p1k0chu.mcmod.bac_tracker.Main;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0007J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001c\u0010&\u001a\n %*\u0004\u0018\u00010\"0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010$R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/github/p1k0chu/mcmod/bac_tracker/utils/Utils;", "", "<init>", "()V", "", "str", "getIdOrUrl", "(Ljava/lang/String;)Ljava/lang/String;", "cell", "", "index", "moveRangeDownBy", "(Ljava/lang/String;I)Ljava/lang/String;", "player", "getProfilePictureByUuid", "Ljava/nio/file/Path;", "credPath", "Lcom/google/api/services/sheets/v4/Sheets;", "buildSheet", "(Ljava/nio/file/Path;)Lcom/google/api/services/sheets/v4/Sheets;", "path", "", "makeSureDirectoryExists", "(Ljava/nio/file/Path;)V", "Lcom/google/gson/JsonObject;", "advJson", "Ljava/time/Instant;", "findLatestCriteriaObtainedDate", "(Lcom/google/gson/JsonObject;)Ljava/time/Instant;", "Lcom/google/api/services/sheets/v4/model/ValueRange;", "range", "", "singleColumnValueRange", "(Lcom/google/api/services/sheets/v4/model/ValueRange;)Ljava/util/List;", "Ljava/util/regex/Pattern;", "rangeRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "googleSheetUrlRegex", "Ljava/time/format/DateTimeFormatter;", "minecraftTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "bac-tracker-mod"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/github/p1k0chu/mcmod/bac_tracker/utils/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1#2:125\n1#2:138\n216#3,2:126\n1611#4,9:128\n1863#4:137\n1864#4:139\n1620#4:140\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/github/p1k0chu/mcmod/bac_tracker/utils/Utils\n*L\n122#1:138\n106#1:126,2\n122#1:128,9\n122#1:137\n122#1:139\n122#1:140\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final Pattern rangeRegex;
    private static final Pattern googleSheetUrlRegex;
    @NotNull
    private static final DateTimeFormatter minecraftTimeFormatter;

    private Utils() {
    }

    @NotNull
    public final String getIdOrUrl(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Matcher m = googleSheetUrlRegex.matcher(str);
        m.find();
        String string = m.group("id");
        if (string == null) {
            string = str;
        }
        return string;
    }

    @Nullable
    public final String moveRangeDownBy(@NotNull String cell, int index) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Matcher m = rangeRegex.matcher(cell);
        if (!m.find()) {
            return null;
        }
        String string = m.group("sL");
        if (string == null) {
            return null;
        }
        String startLetter = string;
        String string2 = m.group("eL");
        if (string2 == null) {
            return null;
        }
        String endLetter = string2;
        String string3 = m.group("sN");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
        Integer n = StringsKt.toIntOrNull((String)string3);
        int startNumber = n != null ? n : 1;
        return startLetter + (startNumber + index) + ":" + endLetter;
    }

    @Nullable
    public final String getProfilePictureByUuid(@Nullable String player) {
        if (player == null) {
            return null;
        }
        return "=IMAGE(\"https://crafatar.com/avatars/" + player + "?size=16&overlay\")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Sheets buildSheet(@NotNull Path credPath) {
        GoogleCredentials googleCredentials;
        Intrinsics.checkNotNullParameter((Object)credPath, (String)"credPath");
        File file = credPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Object[] objectArray = file;
        Object object = Charsets.UTF_8;
        objectArray = new InputStreamReader((InputStream)new FileInputStream((File)objectArray), (Charset)object);
        object = null;
        try {
            Object r = (InputStreamReader)objectArray;
            boolean bl = false;
            Object object2 = Main.INSTANCE.getGSON().fromJson((Reader)r, JsonObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            JsonObject j = (JsonObject)object2;
            r = j.get("client_email").getAsString();
        }
        catch (Throwable r) {
            object = r;
            throw r;
        }
        finally {
            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
        }
        Object email = r;
        HttpTransport httpTransport = (HttpTransport)new NetHttpTransport();
        JsonFactory jsonFactory = (JsonFactory)GsonFactory.getDefaultInstance();
        File file2 = credPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        objectArray = file2;
        objectArray = new FileInputStream((File)objectArray);
        JsonFactory jsonFactory2 = jsonFactory;
        HttpTransport httpTransport2 = httpTransport;
        object = null;
        try {
            FileInputStream stream = (FileInputStream)objectArray;
            boolean bl = false;
            googleCredentials = GoogleCredentials.fromStream((InputStream)stream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
        }
        GoogleCredentials googleCredentials2 = googleCredentials;
        objectArray = new String[]{"https://www.googleapis.com/auth/spreadsheets"};
        Credentials credentials = (Credentials)googleCredentials2.createScoped((Collection)SetsKt.mutableSetOf((Object[])objectArray)).createDelegated((String)email);
        HttpRequestInitializer httpRequestInitializer = (HttpRequestInitializer)new HttpCredentialsAdapter(credentials);
        JsonFactory jsonFactory3 = jsonFactory2;
        HttpTransport httpTransport3 = httpTransport2;
        return new Sheets.Builder(httpTransport3, jsonFactory3, httpRequestInitializer).setApplicationName("BACAP Tracker").build();
    }

    public final void makeSureDirectoryExists(@NotNull Path path) throws IOException, SecurityException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!path.toFile().isDirectory() && !path.toFile().mkdir()) {
            throw new IOException("failed to create new directory: " + path.toAbsolutePath().normalize());
        }
    }

    @Nullable
    public final Instant findLatestCriteriaObtainedDate(@NotNull JsonObject advJson) {
        Intrinsics.checkNotNullParameter((Object)advJson, (String)"advJson");
        Instant max = null;
        Map map = advJson.get("criteria").getAsJsonObject().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"asMap(...)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            JsonElement time = (JsonElement)entry.getValue();
            Instant x = minecraftTimeFormatter.parse((CharSequence)time.getAsString(), Utils::findLatestCriteriaObtainedDate$lambda$3$lambda$2);
            Instant instant = max;
            if (instant != null ? !instant.isBefore(x) : false) continue;
            max = x;
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> singleColumnValueRange(@NotNull ValueRange range) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List list = range.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            List it = (List)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            if ((object != null && (object = CollectionsKt.firstOrNull((List)object)) != null ? object.toString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Instant findLatestCriteriaObtainedDate$lambda$3$lambda$2(TemporalAccessor temporal) {
        return Instant.from(temporal);
    }

    static {
        Pattern pattern = Pattern.compile("(?<sL>\\D+)(?<sN>\\d*):(?<eL>\\D+)", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        rangeRegex = pattern;
        googleSheetUrlRegex = Pattern.compile("https:\\/\\/docs\\.google\\.com\\/spreadsheets\\/d\\/(?<id>.*)\\/edit.*");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        minecraftTimeFormatter = dateTimeFormatter;
    }
}

