/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.noiilive.jojowor.entity.PlayerCloneEntity;

public class PlayerCloneRenderer
extends HumanoidMobRenderer<PlayerCloneEntity, HumanoidModel<PlayerCloneEntity>> {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.parse((String)"jojowor:textures/entities/steve.png");
    private static final String SKIN_FOLDER_NAME = "jojoskins";
    private static final Map<String, ResourceLocation> SKIN_CACHE = new HashMap<String, ResourceLocation>();

    public PlayerCloneRenderer(EntityRendererProvider.Context context) {
        super(context, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
    }

    protected void scale(PlayerCloneEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(0.95f, 0.95f, 0.95f);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ResourceLocation getTextureLocation(PlayerCloneEntity entity) {
        String uuidStr = (String)entity.getEntityData().get(PlayerCloneEntity.DATA_CopyUUID);
        if (uuidStr != null && !uuidStr.isEmpty()) {
            if (SKIN_CACHE.containsKey(uuidStr)) {
                return SKIN_CACHE.get(uuidStr);
            }
            File skinFile = new File(Minecraft.getInstance().gameDirectory, "jojoskins/" + uuidStr + ".png");
            if (skinFile.exists()) {
                try (FileInputStream fis = new FileInputStream(skinFile);){
                    ResourceLocation resourceLocation;
                    block16: {
                        NativeImage img = NativeImage.read((InputStream)fis);
                        try {
                            DynamicTexture dynTex = new DynamicTexture(img);
                            ResourceLocation loc = ResourceLocation.parse((String)("jojowor:skin_" + uuidStr));
                            Minecraft.getInstance().getTextureManager().register(loc, (AbstractTexture)dynTex);
                            SKIN_CACHE.put(uuidStr, loc);
                            resourceLocation = loc;
                            if (img == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return resourceLocation;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return DEFAULT_TEXTURE;
    }
}

