/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.EmotePageLeftProcedure;
import net.noiilive.jojowor.procedures.EmotePageRightProcedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot1Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot2Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot3Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot4Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot5Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot6Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot7Procedure;
import net.noiilive.jojowor.procedures.GUIEmoteSlot8Procedure;
import net.noiilive.jojowor.procedures.OpenMenuGuildInfoProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerSpecSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerStatsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuQuestMainProcedure;
import net.noiilive.jojowor.procedures.OpenMenuSettingsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandStatsProcedure;
import net.noiilive.jojowor.procedures.UnlockEmote1Procedure;
import net.noiilive.jojowor.procedures.UnlockEmote2Procedure;
import net.noiilive.jojowor.procedures.UnlockEmote3Procedure;
import net.noiilive.jojowor.procedures.UnlockEmote4Procedure;
import net.noiilive.jojowor.procedures.UnlockEmote5Procedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MainScreenPlayerEmotesButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MainScreenPlayerEmotesButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"main_screen_player_emotes_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MainScreenPlayerEmotesButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MainScreenPlayerEmotesButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MainScreenPlayerEmotesButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MainScreenPlayerEmotesButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MainScreenPlayerEmotesButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenMenuStandStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenMenuGuildInfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenMenuQuestMainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenMenuPlayerStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenMenuPlayerSpecSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            OpenMenuSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            OpenMenuPlayerSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            UnlockEmote1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            GUIEmoteSlot1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            GUIEmoteSlot2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            GUIEmoteSlot3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            GUIEmoteSlot4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            GUIEmoteSlot5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            GUIEmoteSlot6Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 14) {
            GUIEmoteSlot7Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 15) {
            GUIEmoteSlot8Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 16) {
            UnlockEmote2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 17) {
            EmotePageRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 18) {
            EmotePageLeftProcedure.execute((Entity)entity);
        }
        if (buttonID == 19) {
            UnlockEmote3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 20) {
            UnlockEmote4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 21) {
            UnlockEmote5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, MainScreenPlayerEmotesButtonMessage::handleData);
    }
}

