/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientSkinCacheHandler {
    private static final String SKIN_FOLDER_NAME = "jojoskins";
    private static final Map<UUID, Boolean> cachedSkins = new ConcurrentHashMap<UUID, Boolean>();

    private static NativeImage copyNativeImage(NativeImage original) {
        NativeImage copy = new NativeImage(original.getWidth(), original.getHeight(), false);
        copy.copyFrom(original);
        return copy;
    }

    @SubscribeEvent
    public static void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> {
            if (mc.player == null) {
                return;
            }
            File skinDir = new File(mc.gameDirectory, SKIN_FOLDER_NAME);
            if (!skinDir.exists()) {
                skinDir.mkdirs();
            }
            ClientSkinCacheHandler.savePlayerSkin((Player)mc.player, skinDir);
            mc.level.players().forEach(player -> ClientSkinCacheHandler.savePlayerSkin((Player)player, skinDir));
        });
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Minecraft mc = Minecraft.getInstance();
            mc.execute(() -> {
                File skinDir = new File(mc.gameDirectory, SKIN_FOLDER_NAME);
                if (!skinDir.exists()) {
                    skinDir.mkdirs();
                }
                ClientSkinCacheHandler.savePlayerSkin(player, skinDir);
            });
        }
    }

    private static void savePlayerSkin(Player player, File skinDir) {
        UUID uuid = player.getUUID();
        if (cachedSkins.containsKey(uuid)) {
            return;
        }
        File skinFile = new File(skinDir, String.valueOf(uuid) + ".png");
        if (skinFile.exists()) {
            cachedSkins.put(uuid, true);
            return;
        }
        SkinManager skinManager = Minecraft.getInstance().getSkinManager();
        CompletableFuture future = skinManager.getOrLoad(player.getGameProfile());
        ((CompletableFuture)future.thenAccept(playerSkin -> {
            if (playerSkin == null) {
                return;
            }
            try {
                AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(playerSkin.texture());
                if (texture instanceof DynamicTexture) {
                    DynamicTexture dyn = (DynamicTexture)texture;
                    try (NativeImage img = ClientSkinCacheHandler.copyNativeImage(dyn.getPixels());){
                        img.writeToFile(skinFile);
                    }
                }
                if (playerSkin.textureUrl() != null) {
                    try (InputStream in = new URL(playerSkin.textureUrl()).openStream();
                         FileOutputStream out = new FileOutputStream(skinFile);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                    }
                }
                cachedSkins.put(uuid, true);
                System.out.println("[JoJoWor] Cached skin for " + player.getGameProfile().getName());
            }
            catch (Exception e) {
                System.err.println("[JoJoWor] Failed to save skin for " + player.getGameProfile().getName());
                e.printStackTrace();
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }
}

