/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.noiilive.jojowor.IStandModelProvider;
import net.noiilive.jojowor.StandStateSyncMessage;
import net.noiilive.jojowor.network.JojoworModVariables;

public class StandOverlayLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final EntityModelSet modelSet;
    private Object standModel;
    private ResourceLocation standTexture;
    private ModelPart modelBody;
    private ModelPart modelHead;
    private ModelPart modelLeftArm;
    private ModelPart modelRightArm;
    private ModelPart modelLeftLeg;
    private ModelPart modelRightLeg;

    public StandOverlayLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent, EntityModelSet modelSet) {
        super(parent);
        this.modelSet = modelSet;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        JojoworModVariables.PlayerVariables localVars = (JojoworModVariables.PlayerVariables)localPlayer.getData(JojoworModVariables.PLAYER_VARIABLES);
        if (localVars == null || "None".equals(localVars.PlayerStand)) {
            return;
        }
        StandStateSyncMessage.ClientStandCache.StandData cached = StandStateSyncMessage.ClientStandCache.get(player.getUUID());
        if (cached == null || !cached.summoned()) {
            return;
        }
        IStandModelProvider provider = IStandModelProvider.create(cached.stand(), cached.skin(), this.modelSet);
        if (provider == null) {
            return;
        }
        this.standModel = provider.getModel();
        this.standTexture = provider.getTexture();
        if (this.standModel == null || this.standTexture == null) {
            return;
        }
        this.modelBody = this.getModelPart("Body");
        this.modelHead = this.getModelPart("Head");
        this.modelLeftArm = this.getModelPart("LeftArm");
        this.modelRightArm = this.getModelPart("RightArm");
        this.modelLeftLeg = this.getModelPart("LeftLeg");
        this.modelRightLeg = this.getModelPart("RightLeg");
        PlayerModel parentModel = (PlayerModel)this.getParentModel();
        parentModel.prepareMobModel((LivingEntity)player, limbSwing, limbSwingAmount, partialTicks);
        parentModel.setupAnim((LivingEntity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.copyModelOffsets(parentModel);
        Object object = this.standModel;
        if (object instanceof EntityModel) {
            EntityModel entityModel;
            EntityModel castModel = entityModel = (EntityModel)object;
            castModel.prepareMobModel((Entity)player, limbSwing, limbSwingAmount, partialTicks);
            castModel.setupAnim((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.standTexture));
            castModel.renderToBuffer(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)player, (float)0.0f));
        }
    }

    private void copyModelOffsets(PlayerModel<?> parent) {
        if (this.modelBody != null) {
            this.modelBody.copyFrom(parent.body);
        }
        if (this.modelHead != null) {
            this.modelHead.copyFrom(parent.head);
        }
        if (this.modelLeftArm != null) {
            this.modelLeftArm.copyFrom(parent.leftArm);
        }
        if (this.modelRightArm != null) {
            this.modelRightArm.copyFrom(parent.rightArm);
        }
        if (this.modelLeftLeg != null) {
            this.modelLeftLeg.copyFrom(parent.leftLeg);
        }
        if (this.modelRightLeg != null) {
            this.modelRightLeg.copyFrom(parent.rightLeg);
        }
    }

    private ModelPart getModelPart(String name) {
        try {
            Field field = this.standModel.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (ModelPart)field.get(this.standModel);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

