/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.noiilive.jojowor.init.JojoworModItems;

public class StoneMaskPlacedBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public StoneMaskPlacedBlock() {
        super(BlockBehaviour.Properties.of().strength(0.5f, 1.0f).noCollission().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)StoneMaskPlacedBlock.box((double)3.49, (double)3.49, (double)-7.51, (double)12.51, (double)12.51, (double)1.51), (VoxelShape)StoneMaskPlacedBlock.box((double)3.25, (double)3.25, (double)-7.75, (double)12.75, (double)12.75, (double)1.75));
            case Direction.NORTH -> Shapes.or((VoxelShape)StoneMaskPlacedBlock.box((double)3.49, (double)3.49, (double)14.49, (double)12.51, (double)12.51, (double)23.51), (VoxelShape)StoneMaskPlacedBlock.box((double)3.25, (double)3.25, (double)14.25, (double)12.75, (double)12.75, (double)23.75));
            case Direction.EAST -> Shapes.or((VoxelShape)StoneMaskPlacedBlock.box((double)-7.51, (double)3.49, (double)3.49, (double)1.51, (double)12.51, (double)12.51), (VoxelShape)StoneMaskPlacedBlock.box((double)-7.75, (double)3.25, (double)3.25, (double)1.75, (double)12.75, (double)12.75));
            case Direction.WEST -> Shapes.or((VoxelShape)StoneMaskPlacedBlock.box((double)14.49, (double)3.49, (double)3.49, (double)23.51, (double)12.51, (double)12.51), (VoxelShape)StoneMaskPlacedBlock.box((double)14.25, (double)3.25, (double)3.25, (double)23.75, (double)12.75, (double)12.75));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)JojoworModItems.STONE_MASK_HELMET.get());
    }
}

