/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.noiilive.jojowor.init.JojoworModScreens;
import net.noiilive.jojowor.network.MenuStateUpdateMessage;
import net.noiilive.jojowor.world.inventory.AbilityWheelMenu;
import net.noiilive.jojowor.world.inventory.EmoteWheelMenu;
import net.noiilive.jojowor.world.inventory.MainScreenGuildInfoMenu;
import net.noiilive.jojowor.world.inventory.MainScreenPlayerEmotesMenu;
import net.noiilive.jojowor.world.inventory.MainScreenPlayerSkillsMenu;
import net.noiilive.jojowor.world.inventory.MainScreenPlayerSpecSkillsMenu;
import net.noiilive.jojowor.world.inventory.MainScreenPlayerStatsMenu;
import net.noiilive.jojowor.world.inventory.MainScreenQuestsMainMenu;
import net.noiilive.jojowor.world.inventory.MainScreenQuestsSideMenu;
import net.noiilive.jojowor.world.inventory.MainScreenStandSkillsMenu;
import net.noiilive.jojowor.world.inventory.MainScreenStandSkinsMenu;
import net.noiilive.jojowor.world.inventory.MainScreenStandStatsMenu;
import net.noiilive.jojowor.world.inventory.SettingsMenuMenu;

public class JojoworModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"jojowor");
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenPlayerStatsMenu>> MAIN_SCREEN_PLAYER_STATS = REGISTRY.register("main_screen_player_stats", () -> IMenuTypeExtension.create(MainScreenPlayerStatsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenPlayerSkillsMenu>> MAIN_SCREEN_PLAYER_SKILLS = REGISTRY.register("main_screen_player_skills", () -> IMenuTypeExtension.create(MainScreenPlayerSkillsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenPlayerSpecSkillsMenu>> MAIN_SCREEN_PLAYER_SPEC_SKILLS = REGISTRY.register("main_screen_player_spec_skills", () -> IMenuTypeExtension.create(MainScreenPlayerSpecSkillsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenStandStatsMenu>> MAIN_SCREEN_STAND_STATS = REGISTRY.register("main_screen_stand_stats", () -> IMenuTypeExtension.create(MainScreenStandStatsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenStandSkillsMenu>> MAIN_SCREEN_STAND_SKILLS = REGISTRY.register("main_screen_stand_skills", () -> IMenuTypeExtension.create(MainScreenStandSkillsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenStandSkinsMenu>> MAIN_SCREEN_STAND_SKINS = REGISTRY.register("main_screen_stand_skins", () -> IMenuTypeExtension.create(MainScreenStandSkinsMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenGuildInfoMenu>> MAIN_SCREEN_GUILD_INFO = REGISTRY.register("main_screen_guild_info", () -> IMenuTypeExtension.create(MainScreenGuildInfoMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenQuestsMainMenu>> MAIN_SCREEN_QUESTS_MAIN = REGISTRY.register("main_screen_quests_main", () -> IMenuTypeExtension.create(MainScreenQuestsMainMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenQuestsSideMenu>> MAIN_SCREEN_QUESTS_SIDE = REGISTRY.register("main_screen_quests_side", () -> IMenuTypeExtension.create(MainScreenQuestsSideMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<AbilityWheelMenu>> ABILITY_WHEEL = REGISTRY.register("ability_wheel", () -> IMenuTypeExtension.create(AbilityWheelMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<SettingsMenuMenu>> SETTINGS_MENU = REGISTRY.register("settings_menu", () -> IMenuTypeExtension.create(SettingsMenuMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<MainScreenPlayerEmotesMenu>> MAIN_SCREEN_PLAYER_EMOTES = REGISTRY.register("main_screen_player_emotes", () -> IMenuTypeExtension.create(MainScreenPlayerEmotesMenu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<EmoteWheelMenu>> EMOTE_WHEEL = REGISTRY.register("emote_wheel", () -> IMenuTypeExtension.create(EmoteWheelMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof JojoworModScreens.ScreenAccessor) {
                    JojoworModScreens.ScreenAccessor accessor = (JojoworModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

