/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.DecreasePositionXProcedure;
import net.noiilive.jojowor.procedures.DecreasePositionYProcedure;
import net.noiilive.jojowor.procedures.DecreasePositionZProcedure;
import net.noiilive.jojowor.procedures.DecreaseRotationProcedure;
import net.noiilive.jojowor.procedures.IncreasePositionXProcedure;
import net.noiilive.jojowor.procedures.IncreasePositionYProcedure;
import net.noiilive.jojowor.procedures.IncreasePositionZProcedure;
import net.noiilive.jojowor.procedures.IncreaseRotationProcedure;
import net.noiilive.jojowor.procedures.NextIdleProcedure;
import net.noiilive.jojowor.procedures.OpenMenuGuildInfoProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerStatsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuQuestMainProcedure;
import net.noiilive.jojowor.procedures.OpenMenuSettingsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandStatsProcedure;
import net.noiilive.jojowor.procedures.PreviousIdleProcedure;
import net.noiilive.jojowor.procedures.StandPositionResetButtonProcedure;
import net.noiilive.jojowor.procedures.StandSkinButtonBaseProcedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin2Procedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin3Procedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin4Procedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin5Procedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin6Procedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin7Procedure;
import net.noiilive.jojowor.procedures.StandSkinButtonSkin8Procedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MainScreenStandSkinsButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MainScreenStandSkinsButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"main_screen_stand_skins_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MainScreenStandSkinsButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MainScreenStandSkinsButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MainScreenStandSkinsButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MainScreenStandSkinsButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MainScreenStandSkinsButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenMenuPlayerStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenMenuGuildInfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenMenuQuestMainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenMenuStandStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenMenuStandSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            StandSkinButtonBaseProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            StandSkinButtonSkin2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            OpenMenuSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            StandSkinButtonSkin3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            StandSkinButtonSkin4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            StandSkinButtonSkin5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            StandSkinButtonSkin6Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            StandSkinButtonSkin7Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            StandSkinButtonSkin8Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 14) {
            StandPositionResetButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            DecreasePositionXProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 16) {
            IncreasePositionXProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 17) {
            IncreasePositionYProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 18) {
            DecreasePositionYProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 19) {
            IncreasePositionZProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 20) {
            DecreasePositionZProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 21) {
            DecreaseRotationProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 22) {
            IncreaseRotationProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 23) {
            PreviousIdleProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 24) {
            NextIdleProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, MainScreenStandSkinsButtonMessage::handleData);
    }
}

