/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.procedures;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.noiilive.jojowor.init.JojoworModMobEffects;
import net.noiilive.jojowor.network.JojoworModVariables;

@EventBusSubscriber
public class EntityHurtTimeStopProcedure {
    private static final String DAMAGE_ACCUMULATOR_TAG = "TimeStopAccumulatedDamage";
    private static final TagKey<DamageType> IGNORE_DAMAGE_TAG = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"jojowor:timestop_ignore"));

    @SubscribeEvent
    public static void onEntityAttacked(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = livingEntity;
        Level world = entity.level();
        JojoworModVariables.MapVariables mapVars = JojoworModVariables.MapVariables.get((LevelAccessor)world);
        if (!mapVars.TimeStopGlobal) {
            return;
        }
        boolean hasTimeStopMovement = entity.hasEffect(JojoworModMobEffects.TIMESTOP_MOVEMENT);
        boolean isOriginator = mapVars.TimeStopGlobalOrigin.equals(entity.getDisplayName().getString());
        if (hasTimeStopMovement || isOriginator) {
            return;
        }
        DamageSource damageSource = event.getSource();
        Holder typeHolder = damageSource.typeHolder();
        if (typeHolder.is(IGNORE_DAMAGE_TAG)) {
            event.getContainer().setNewDamage(0.0f);
            EntityHurtTimeStopProcedure.clearHurtAnimation(entity);
            return;
        }
        float incoming = event.getContainer().getNewDamage();
        event.getContainer().setNewDamage(0.0f);
        EntityHurtTimeStopProcedure.accumulateDamage(entity, incoming);
        EntityHurtTimeStopProcedure.clearHurtAnimation(entity);
    }

    private static void clearHurtAnimation(LivingEntity entity) {
        entity.hurtTime = 0;
        entity.hurtDuration = 0;
        entity.hurtMarked = false;
        entity.invulnerableTime = 0;
    }

    private static void accumulateDamage(LivingEntity entity, float damage) {
        CompoundTag data = entity.getPersistentData();
        double current = data.getDouble(DAMAGE_ACCUMULATOR_TAG);
        data.putDouble(DAMAGE_ACCUMULATOR_TAG, current + (double)damage);
    }

    public static void applyAccumulatedDamage(LivingEntity entity) {
        CompoundTag data = entity.getPersistentData();
        double dmg = data.getDouble(DAMAGE_ACCUMULATOR_TAG);
        if (dmg > 0.0) {
            entity.hurt(entity.damageSources().magic(), (float)dmg);
            data.putDouble(DAMAGE_ACCUMULATOR_TAG, 0.0);
        }
    }
}

