/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.server.event;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.noiilive.jojowor.entity.PlayerCloneEntity;
import net.noiilive.jojowor.network.JojoworModVariables;

@EventBusSubscriber
public class PlayerMobIgnoreHandler {
    private static final double CLONE_TARGET_RADIUS = 20.0;

    @SubscribeEvent
    public static void onMobSetTarget(LivingChangeTargetEvent event) {
        LivingEntity mobEntity = event.getEntity();
        LivingEntity target = event.getNewAboutToBeSetTarget();
        if (!(mobEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)mobEntity;
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        if (PlayerMobIgnoreHandler.shouldIgnorePlayer(mob, player)) {
            PlayerCloneEntity clone = PlayerMobIgnoreHandler.findNearbyCloneWithLOS(player, mob, 20.0);
            if (clone != null) {
                event.setNewAboutToBeSetTarget((LivingEntity)clone);
            } else {
                event.setNewAboutToBeSetTarget(null);
            }
        }
    }

    private static boolean shouldIgnorePlayer(Mob mob, Player player) {
        JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
        if (vars == null || !vars.StandPiloting) {
            return false;
        }
        CompoundTag mobNbt = mob.getPersistentData();
        String mobStandTag = mobNbt.getString("Stand");
        return mobStandTag.isEmpty() || mobStandTag.equals("None");
    }

    private static PlayerCloneEntity findNearbyCloneWithLOS(Player player, Mob mob, double radius) {
        AABB searchArea = mob.getBoundingBox().inflate(radius);
        for (PlayerCloneEntity clone : mob.level().getEntitiesOfClass(PlayerCloneEntity.class, searchArea)) {
            String ownerUUIDString = (String)clone.getEntityData().get(PlayerCloneEntity.DATA_CopyUUID);
            UUID ownerUUID = null;
            if (ownerUUIDString != null && !ownerUUIDString.isEmpty()) {
                try {
                    ownerUUID = UUID.fromString(ownerUUIDString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (ownerUUID == null || !ownerUUID.equals(player.getUUID()) || !mob.hasLineOfSight((Entity)clone)) continue;
            return clone;
        }
        return null;
    }
}

