/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.noiilive.jojowor.entity.SilverChariotEntity;
import net.noiilive.jojowor.entity.model.SilverChariotModel;
import net.noiilive.jojowor.network.JojoworModVariables;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.Color;

public class SilverChariotRenderer
extends GeoEntityRenderer<SilverChariotEntity> {
    private static final String LEFT_HAND = "LeftHand";
    private static final String RIGHT_HAND = "RightHand";
    protected ItemStack mainHandItem = ItemStack.EMPTY;
    protected ItemStack offHandItem = ItemStack.EMPTY;

    public SilverChariotRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SilverChariotModel());
        this.shadowRadius = 0.0f;
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<SilverChariotEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, SilverChariotEntity animatable) {
                return switch (bone.getName()) {
                    case SilverChariotRenderer.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield SilverChariotRenderer.this.mainHandItem;
                        }
                        yield SilverChariotRenderer.this.offHandItem;
                    }
                    case SilverChariotRenderer.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield SilverChariotRenderer.this.offHandItem;
                        }
                        yield SilverChariotRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, SilverChariotEntity animatable) {
                return bone.getName().equals(SilverChariotRenderer.LEFT_HAND) || bone.getName().equals(SilverChariotRenderer.RIGHT_HAND) ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.NONE;
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, SilverChariotEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                if (stack.getItem() instanceof ShieldItem) {
                    if (stack == SilverChariotRenderer.this.mainHandItem) {
                        poseStack.translate(0.0, 0.075, 0.025);
                    } else {
                        poseStack.translate(0.0, 0.0, 0.375);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                poseStack.scale(1.0f, 1.0f, 1.0f);
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(SilverChariotEntity entity) {
        if (entity.overrideTexture != null) {
            return entity.overrideTexture;
        }
        String textureString = entity.getTexture();
        return ResourceLocation.parse((String)("jojowor:textures/entities/" + textureString + ".png"));
    }

    public RenderType getRenderType(SilverChariotEntity entity, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && entity.getOwnerUUID() != null && entity.getOwnerUUID().equals(player.getUUID()) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return RenderType.entityNoOutline((ResourceLocation)this.getTextureLocation(entity));
        }
        return RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(entity));
    }

    public void preRender(PoseStack poseStack, SilverChariotEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.mainHandItem = entity.getMainHandItem();
        this.offHandItem = entity.getOffhandItem();
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    protected float getDeathMaxRotation(SilverChariotEntity entity) {
        return 0.0f;
    }

    public Color getRenderColor(SilverChariotEntity animatable, float partialTick, int packedLight) {
        LocalPlayer player;
        boolean isGuiPreview;
        boolean bl = isGuiPreview = animatable.tickCount == 0 && (animatable.level() == null || animatable.level().getEntity(animatable.getId()) == null);
        float alpha = isGuiPreview ? 1.0f : ((player = Minecraft.getInstance().player) != null && animatable.getOwnerUUID() != null && animatable.getOwnerUUID().equals(player.getUUID()) && Minecraft.getInstance().options.getCameraType().isFirstPerson() ? 0.2f : animatable.getFadeAlpha());
        int alphaInt = (int)(alpha * 255.0f);
        int argb = alphaInt << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        return new Color(argb);
    }

    public boolean shouldRender(SilverChariotEntity entity, Frustum frustum, double x, double y, double z) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            JojoworModVariables.PlayerVariables vars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
            if ("None".equals(vars.PlayerStand)) {
                return false;
            }
        }
        return super.shouldRender((Entity)entity, frustum, x, y, z);
    }
}

