/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.entity;

import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.noiilive.jojowor.procedures.PlayerCloneHitProcedure;
import net.noiilive.jojowor.procedures.PlayerCloneTickProcedure;

public class PlayerCloneEntity
extends PathfinderMob {
    public static final EntityDataAccessor<String> DATA_CopyUUID = SynchedEntityData.defineId(PlayerCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public PlayerCloneEntity(EntityType<PlayerCloneEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setCustomName((Component)Component.literal((String)"Player"));
        this.setCustomNameVisible(true);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CopyUUID, (Object)"");
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        PlayerCloneEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        PlayerCloneHitProcedure.execute((LevelAccessor)world, (Entity)entity);
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCopyUUID", (String)this.entityData.get(DATA_CopyUUID));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCopyUUID")) {
            this.entityData.set(DATA_CopyUUID, (Object)compound.getString("DataCopyUUID"));
        }
    }

    public void baseTick() {
        super.baseTick();
        PlayerCloneTickProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }

    public boolean isCustomNameVisible() {
        return true;
    }

    public void tick() {
        super.tick();
        String copyUUIDStr = (String)this.entityData.get(DATA_CopyUUID);
        if (copyUUIDStr != null && !copyUUIDStr.isEmpty() && this.level() != null) {
            UUID copyUUID;
            try {
                copyUUID = UUID.fromString(copyUUIDStr);
            }
            catch (IllegalArgumentException e) {
                copyUUID = null;
            }
            if (copyUUID != null) {
                for (Player player : this.level().players()) {
                    if (!player.getUUID().equals(copyUUID)) continue;
                    this.setXRot(player.getXRot());
                    this.setYHeadRot(player.getYHeadRot());
                    break;
                }
            }
        }
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }
}

