/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.mixins;

import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.noiilive.jojowor.ZoomHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public class ZoomRenderMixin {
    @Inject(method={"getFov"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetFov(Camera camera, float partialTick, boolean useFovModifier, CallbackInfoReturnable<Double> cir) {
        double zoomLevel = ZoomHandler.getZoomLevel();
        if (zoomLevel != 1.0 && zoomLevel > 0.0) {
            double originalFov = (Double)cir.getReturnValue();
            double newFov = originalFov / zoomLevel;
            cir.setReturnValue((Object)newFov);
        }
    }
}

