/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.GUISkillSlot1aProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot1bProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot2aProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot2bProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot3aProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot3bProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot4aProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot4bProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot5aProcedure;
import net.noiilive.jojowor.procedures.GUISkillSlot5bProcedure;
import net.noiilive.jojowor.procedures.OpenMenuGuildInfoProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerSpecSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerStatsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuQuestMainProcedure;
import net.noiilive.jojowor.procedures.OpenMenuSettingsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandStatsProcedure;
import net.noiilive.jojowor.procedures.SkillButtonBarrageProcedure;
import net.noiilive.jojowor.procedures.SkillButtonHeavyAttackProcedure;
import net.noiilive.jojowor.procedures.SkillButtonLeapProcedure;
import net.noiilive.jojowor.procedures.SkillButtonSlamProcedure;
import net.noiilive.jojowor.procedures.SkillButtonUppercutProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MainScreenPlayerSkillsButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MainScreenPlayerSkillsButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"main_screen_player_skills_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MainScreenPlayerSkillsButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MainScreenPlayerSkillsButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MainScreenPlayerSkillsButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MainScreenPlayerSkillsButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MainScreenPlayerSkillsButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenMenuStandStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenMenuGuildInfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenMenuQuestMainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenMenuPlayerStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenMenuPlayerSpecSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            SkillButtonHeavyAttackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            SkillButtonLeapProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            SkillButtonUppercutProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            SkillButtonSlamProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            SkillButtonBarrageProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            GUISkillSlot1aProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 11) {
            GUISkillSlot2aProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            GUISkillSlot3aProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 13) {
            GUISkillSlot4aProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 14) {
            GUISkillSlot5aProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 15) {
            GUISkillSlot1bProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 16) {
            GUISkillSlot2bProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 17) {
            GUISkillSlot3bProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 18) {
            GUISkillSlot4bProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 19) {
            GUISkillSlot5bProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 20) {
            OpenMenuSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, MainScreenPlayerSkillsButtonMessage::handleData);
    }
}

