/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.AddPlayerSkillPointsProcedure;
import net.noiilive.jojowor.procedures.AddPointAgilityProcedure;
import net.noiilive.jojowor.procedures.AddPointIntelligenceProcedure;
import net.noiilive.jojowor.procedures.AddPointStrengthProcedure;
import net.noiilive.jojowor.procedures.AddPointVitalityProcedure;
import net.noiilive.jojowor.procedures.OpenMenuGuildInfoProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerSpecSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuQuestMainProcedure;
import net.noiilive.jojowor.procedures.OpenMenuSettingsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandStatsProcedure;
import net.noiilive.jojowor.procedures.RemovePlayerSkillPointsProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MainScreenPlayerStatsButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MainScreenPlayerStatsButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"main_screen_player_stats_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MainScreenPlayerStatsButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MainScreenPlayerStatsButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MainScreenPlayerStatsButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MainScreenPlayerStatsButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MainScreenPlayerStatsButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenMenuQuestMainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenMenuPlayerSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            AddPointStrengthProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            AddPointVitalityProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            AddPointAgilityProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            AddPointIntelligenceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            OpenMenuStandStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            OpenMenuGuildInfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            OpenMenuPlayerSpecSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            RemovePlayerSkillPointsProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            AddPlayerSkillPointsProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 11) {
            OpenMenuSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, MainScreenPlayerStatsButtonMessage::handleData);
    }
}

