/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.procedures;

import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.noiilive.jojowor.init.JojoworModItems;

public class RapierLungeAttackProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        int n;
        if (entity == null) {
            return;
        }
        double vecZ = 0.0;
        double vecY = 0.0;
        double vecX = 0.0;
        double magnitude = 0.0;
        double distance = 0.0;
        double damage = 0.0;
        if (entity instanceof LivingEntity) {
            LivingEntity _entUseTicks0 = (LivingEntity)entity;
            n = _entUseTicks0.getTicksUsingItem();
        } else {
            n = 0;
        }
        if (n > 10) {
            int n2;
            ServerLevel _level;
            if (itemstack.getItem() == JojoworModItems.WOODEN_RAPIER.get()) {
                distance = 0.5;
                damage = 3.0;
            } else if (itemstack.getItem() == JojoworModItems.GOLDEN_RAPIER.get()) {
                distance = 1.0;
                damage = 3.0;
            } else if (itemstack.getItem() == JojoworModItems.STONE_RAPIER.get()) {
                distance = 0.75;
                damage = 4.0;
            } else if (itemstack.getItem() == JojoworModItems.IRON_RAPIER.get()) {
                distance = 1.0;
                damage = 5.0;
            } else if (itemstack.getItem() == JojoworModItems.DIAMOND_RAPIER.get()) {
                distance = 1.25;
                damage = 6.0;
            } else if (itemstack.getItem() == JojoworModItems.NETHERITE_RAPIER.get()) {
                distance = 1.5;
                damage = 7.0;
            } else if (itemstack.getItem() == JojoworModItems.POLNAREFFS_RAPIER.get()) {
                distance = 1.75;
                damage = 7.0;
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(x, y, z), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), "playsound jojowor:whoosh player @a ~ ~ ~ 1 1");
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y + 1.0, z, 20, 0.5, 0.5, 0.5, 0.1);
            }
            magnitude = Math.sqrt(entity.getLookAngle().x * entity.getLookAngle().x + entity.getLookAngle().y * entity.getLookAngle().y + entity.getLookAngle().z * entity.getLookAngle().z);
            vecX = entity.getLookAngle().x / magnitude;
            vecZ = entity.getLookAngle().z / magnitude;
            if (entity instanceof LivingEntity) {
                LivingEntity _entUseTicks25 = (LivingEntity)entity;
                n2 = _entUseTicks25.getTicksUsingItem();
            } else {
                n2 = 0;
            }
            distance += (double)(n2 / 100);
            if (distance >= 3.0) {
                distance = 3.0;
            }
            vecY = 0.1;
            entity.push(vecX *= distance, vecY, vecZ *= distance);
            if (entity instanceof Player) {
                Player _player = (Player)entity;
                _player.getCooldowns().addCooldown(itemstack.getItem(), 100);
            }
            if (RapierLungeAttackProcedure.getEntityGameType(entity) != GameType.CREATIVE && world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                itemstack.hurtAndBreak(1, _level, null, _stkprov -> {});
            }
            Vec3 _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                if (entityiterator == entity || entityiterator.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)"jojowor:non_targetable")))) continue;
                entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)damage);
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

