/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.noiilive.jojowor.client.model.Modelhermit_purple;
import net.noiilive.jojowor.network.JojoworModVariables;

public class StandOverlayLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final Modelhermit_purple model;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"textures/entities/stand_hermitpurple.png");
    private final ModelPart modelBody;
    private final ModelPart modelHead;
    private final ModelPart modelLeftArm;
    private final ModelPart modelRightArm;
    private final ModelPart modelLeftLeg;
    private final ModelPart modelRightLeg;

    public StandOverlayLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent, EntityModelSet modelSet) {
        super(parent);
        this.model = new Modelhermit_purple(modelSet.bakeLayer(Modelhermit_purple.LAYER_LOCATION));
        this.modelBody = this.getModelPart("Body");
        this.modelHead = this.getModelPart("Head");
        this.modelLeftArm = this.getModelPart("LeftArm");
        this.modelRightArm = this.getModelPart("RightArm");
        this.modelLeftLeg = this.getModelPart("LeftLeg");
        this.modelRightLeg = this.getModelPart("RightLeg");
    }

    private ModelPart getModelPart(String name) {
        try {
            Field field = Modelhermit_purple.class.getDeclaredField(name);
            field.setAccessible(true);
            return (ModelPart)field.get((Object)this.model);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to access ModelPart " + name + " in Modelhermit_purple", e);
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        JojoworModVariables.PlayerVariables targetVars = (JojoworModVariables.PlayerVariables)player.getData(JojoworModVariables.PLAYER_VARIABLES);
        if (targetVars == null || !"Hermit Purple".equals(targetVars.PlayerStand) || !Boolean.TRUE.equals(targetVars.StandSummoned)) {
            return;
        }
        PlayerModel parentModel = (PlayerModel)this.getParentModel();
        parentModel.prepareMobModel((LivingEntity)player, limbSwing, limbSwingAmount, partialTicks);
        parentModel.setupAnim((LivingEntity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        parentModel.copyPropertiesTo((EntityModel)this.model);
        this.syncModelOffsetsAndRotations(parentModel);
        this.model.prepareMobModel((Entity)player, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)player, (float)0.0f));
    }

    private void syncModelOffsetsAndRotations(PlayerModel<?> from) {
        this.modelBody.x = from.body.x;
        this.modelBody.y = from.body.y;
        this.modelBody.z = from.body.z;
        this.modelBody.xRot = from.body.xRot;
        this.modelBody.yRot = from.body.yRot;
        this.modelBody.zRot = from.body.zRot;
        this.modelHead.x = from.head.x;
        this.modelHead.y = from.head.y;
        this.modelHead.z = from.head.z;
        this.modelHead.xRot = from.head.xRot;
        this.modelHead.yRot = from.head.yRot;
        this.modelHead.zRot = from.head.zRot;
        this.modelLeftArm.x = from.leftArm.x;
        this.modelLeftArm.y = from.leftArm.y;
        this.modelLeftArm.z = from.leftArm.z;
        this.modelLeftArm.xRot = from.leftArm.xRot;
        this.modelLeftArm.yRot = from.leftArm.yRot;
        this.modelLeftArm.zRot = from.leftArm.zRot;
        this.modelRightArm.x = from.rightArm.x;
        this.modelRightArm.y = from.rightArm.y;
        this.modelRightArm.z = from.rightArm.z;
        this.modelRightArm.xRot = from.rightArm.xRot;
        this.modelRightArm.yRot = from.rightArm.yRot;
        this.modelRightArm.zRot = from.rightArm.zRot;
        this.modelLeftLeg.x = from.leftLeg.x;
        this.modelLeftLeg.y = from.leftLeg.y;
        this.modelLeftLeg.z = from.leftLeg.z;
        this.modelLeftLeg.xRot = from.leftLeg.xRot;
        this.modelLeftLeg.yRot = from.leftLeg.yRot;
        this.modelLeftLeg.zRot = from.leftLeg.zRot;
        this.modelRightLeg.x = from.rightLeg.x;
        this.modelRightLeg.y = from.rightLeg.y;
        this.modelRightLeg.z = from.rightLeg.z;
        this.modelRightLeg.xRot = from.rightLeg.xRot;
        this.modelRightLeg.yRot = from.rightLeg.yRot;
        this.modelRightLeg.zRot = from.rightLeg.zRot;
    }

    private ResourceLocation getTexture(AbstractClientPlayer player) {
        return TEXTURE;
    }
}

