/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.noiilive.jojowor.procedures.BloodDripOnGroundProcedure;

@OnlyIn(value=Dist.CLIENT)
public class BloodDripParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static BloodDripParticleProvider provider(SpriteSet spriteSet) {
        return new BloodDripParticleProvider(spriteSet);
    }

    protected BloodDripParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.2f, 0.2f);
        this.quadSize *= 1.3f;
        this.lifetime = Math.max(1, 10 + (this.random.nextInt(60) - 30));
        this.gravity = 1.0f;
        this.hasPhysics = true;
        this.xd = vx * 1.0;
        this.yd = vy * 1.0;
        this.zd = vz * 1.0;
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
        ClientLevel world = this.level;
        if (BloodDripOnGroundProcedure.execute((LevelAccessor)world, this.x, this.y, this.z, this.onGround)) {
            this.remove();
        }
    }

    public static class BloodDripParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BloodDripParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BloodDripParticle particle = new BloodDripParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return particle;
        }
    }
}

