/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.jojowor.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.noiilive.jojowor.JojoworMod;
import net.noiilive.jojowor.procedures.AddPlayerSkillPointsProcedure;
import net.noiilive.jojowor.procedures.AddPointEnduranceProcedure;
import net.noiilive.jojowor.procedures.AddPointPotentialProcedure;
import net.noiilive.jojowor.procedures.AddPointPowerProcedure;
import net.noiilive.jojowor.procedures.AddPointPrecisionProcedure;
import net.noiilive.jojowor.procedures.AddPointSpeedProcedure;
import net.noiilive.jojowor.procedures.OpenMenuGuildInfoProcedure;
import net.noiilive.jojowor.procedures.OpenMenuPlayerStatsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuQuestMainProcedure;
import net.noiilive.jojowor.procedures.OpenMenuSettingsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandSkillsProcedure;
import net.noiilive.jojowor.procedures.OpenMenuStandSkinsProcedure;
import net.noiilive.jojowor.procedures.RemovePlayerSkillPointsProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MainScreenStandStatsButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MainScreenStandStatsButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"jojowor", (String)"main_screen_stand_stats_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MainScreenStandStatsButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MainScreenStandStatsButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MainScreenStandStatsButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MainScreenStandStatsButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MainScreenStandStatsButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenMenuPlayerStatsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenMenuGuildInfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenMenuQuestMainProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            OpenMenuStandSkillsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenMenuStandSkinsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            RemovePlayerSkillPointsProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            AddPlayerSkillPointsProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            AddPointPowerProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            AddPointSpeedProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            AddPointEnduranceProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            AddPointPrecisionProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            AddPointPotentialProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            OpenMenuSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JojoworMod.addNetworkMessage(TYPE, STREAM_CODEC, MainScreenStandStatsButtonMessage::handleData);
    }
}

